/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.HashMap;
import java.util.Map;
import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.compiler.parser.BoxSourceType;
import ortus.boxlang.runtime.bifs.BIFDescriptor;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.LocalScope;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.util.ArgumentUtil;

public class FunctionBoxContext
extends BaseBoxContext {
    protected ArgumentsScope argumentsScope;
    protected IScope localScope;
    protected Function function;
    protected IClassRunnable enclosingBoxClass = null;
    protected DynamicObject enclosingStaticBoxClass = null;
    protected BoxInterface enclosingBoxInterface = null;
    protected Key functionCalledName;

    public FunctionBoxContext(IBoxContext parent, Function function) {
        this(parent, function, function.getName());
    }

    public FunctionBoxContext(IBoxContext parent, Function function, Key functionCalledName) {
        this(parent, function, functionCalledName, new ArgumentsScope());
    }

    public FunctionBoxContext(IBoxContext parent, Function function, ArgumentsScope argumentsScope) {
        this(parent, function, function.getName(), argumentsScope);
    }

    public FunctionBoxContext(IBoxContext parent, Function function, Key functionCalledName, ArgumentsScope argumentsScope) {
        super(parent);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for FunctionBoxContext");
        }
        if (function == null) {
            throw new BoxRuntimeException("function cannot be null for FunctionBoxContext");
        }
        this.localScope = new LocalScope();
        this.argumentsScope = argumentsScope;
        this.function = function;
        this.functionCalledName = functionCalledName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionBoxContext(IBoxContext parent, Function function, Key functionCalledName, Object[] positionalArguments, IClassRunnable thisClass) {
        super(parent);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for FunctionBoxContext");
        }
        if (function == null) {
            throw new BoxRuntimeException("function cannot be null for FunctionBoxContext");
        }
        this.localScope = new LocalScope();
        this.argumentsScope = new ArgumentsScope();
        this.function = function;
        this.functionCalledName = functionCalledName;
        this.setThisClass(thisClass);
        this.pushTemplate(function);
        try {
            ArgumentUtil.createArgumentsScope((IBoxContext)this, positionalArguments, function.getArguments(), this.argumentsScope, function.getName());
        }
        finally {
            this.popTemplate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FunctionBoxContext(IBoxContext parent, Function function, Key functionCalledName, Map<Key, Object> namedArguments, IClassRunnable thisClass) {
        super(parent);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for FunctionBoxContext");
        }
        if (function == null) {
            throw new BoxRuntimeException("function cannot be null for FunctionBoxContext");
        }
        this.localScope = new LocalScope();
        this.argumentsScope = new ArgumentsScope();
        this.function = function;
        this.functionCalledName = functionCalledName;
        this.setThisClass(thisClass);
        this.pushTemplate(function);
        try {
            ArgumentUtil.createArgumentsScope((IBoxContext)this, namedArguments, function.getArguments(), this.argumentsScope, function.getName());
        }
        finally {
            this.popTemplate();
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue()) {
            this.getParent().getVisibleScopes(scopes, true, shallow);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(ArgumentsScope.name, (Object)this.argumentsScope);
            scopes.getAsStruct(Key.contextual).put(LocalScope.name, (Object)this.localScope);
        }
        if (this.isInClass()) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.getThisClass().getBottomClass().getVariablesScope());
            scopes.getAsStruct(Key.contextual).put(StaticScope.name, (Object)this.getThisClass().getStaticScope());
        }
        return scopes;
    }

    public Function getFunction() {
        return this.function;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (key.equals(BoxMeta.key) && this.isInClass()) {
            return new IBoxContext.ScopeSearchResult(this.getThisClass().getBottomClass(), this.getThisClass().getBottomClass().getBoxMeta(), BoxMeta.key, false);
        }
        if (key.equals(this.localScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.localScope, this.localScope, key, true);
        }
        if (key.equals(this.argumentsScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, this.argumentsScope, key, true);
        }
        IBoxContext.ScopeSearchResult thisSerach = this.scopeFindThis(key);
        if (thisSerach != null) {
            return thisSerach;
        }
        IBoxContext.ScopeSearchResult superSearch = this.scopeFindSuper(key);
        if (superSearch != null) {
            return superSearch;
        }
        if (key.equals(StaticScope.name) && this.isInClass()) {
            return new IBoxContext.ScopeSearchResult(this.getThisClass().getStaticScope(), this.getThisClass().getStaticScope(), key, true);
        }
        if (key.equals(StaticScope.name) && this.isInStaticClass()) {
            StaticScope staticScope = BoxClassSupport.getStaticScope(this, this.getThisStaticClass());
            return new IBoxContext.ScopeSearchResult(staticScope, staticScope, key, true);
        }
        if (key.equals(StaticScope.name) && this.isInInterface()) {
            StaticScope staticScope = this.getThisInterface().getStaticScope();
            return new IBoxContext.ScopeSearchResult(staticScope, staticScope, key, true);
        }
        Object result = this.localScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.localScope, Struct.unWrapNull(result), key);
        }
        result = this.argumentsScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, Struct.unWrapNull(result), key);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        if (this.isInClass()) {
            VariablesScope classVariablesScope = this.getThisClass().getBottomClass().getVariablesScope();
            result = classVariablesScope.getRaw(key);
            if (result != null) {
                return new IBoxContext.ScopeSearchResult(classVariablesScope, Struct.unWrapNull(result), key);
            }
            if (shallow) {
                return null;
            }
            return this.parent.scopeFind(key, defaultScope);
        }
        if (shallow) {
            return this.parent.scopeFindNearby(key, defaultScope, true);
        }
        return this.parent.scopeFindNearby(key, defaultScope);
    }

    protected IBoxContext.ScopeSearchResult scopeFindThis(Key key) {
        if (key.equals(ThisScope.name) && this.isInClass()) {
            return new IBoxContext.ScopeSearchResult(this.getThisClass().getBottomClass(), this.getThisClass().getBottomClass(), key, true);
        }
        return null;
    }

    protected IBoxContext.ScopeSearchResult scopeFindSuper(Key key) {
        if (key.equals(Key._super) && this.getThisClass() != null) {
            if (this.getThisClass().getSuper() != null) {
                return new IBoxContext.ScopeSearchResult(this.getThisClass().getSuper(), this.getThisClass().getSuper(), key, true);
            }
            if (this.getThisClass().isJavaExtends()) {
                DynamicObject jSuper = DynamicObject.of(this.getThisClass()).setTargetClass(this.getThisClass().getClass().getSuperclass());
                return new IBoxContext.ScopeSearchResult(jSuper, jSuper, key, true);
            }
        }
        return null;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.localScope.getName())) {
            return this.localScope;
        }
        if (name.equals(this.argumentsScope.getName())) {
            return this.argumentsScope;
        }
        if (this.isInClass()) {
            if (name.equals(VariablesScope.name)) {
                return this.getThisClass().getBottomClass().getVariablesScope();
            }
            if (shallow) {
                return null;
            }
            return this.parent.getScope(name);
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScopeNearby(name);
    }

    @Override
    public Key findClosestFunctionName() {
        return this.functionCalledName;
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.getFunction().getSourceType().equals((Object)BoxSourceType.CFSCRIPT) || this.getFunction().getSourceType().equals((Object)BoxSourceType.CFTEMPLATE) ? this.getScopeNearby(VariablesScope.name) : this.localScope;
    }

    @Override
    public IBoxContext getFunctionParentContext() {
        return this.getParent();
    }

    public boolean isInClass() {
        return this.enclosingBoxClass != null;
    }

    public IClassRunnable getThisClass() {
        return this.enclosingBoxClass;
    }

    public FunctionBoxContext setThisClass(IClassRunnable enclosingBoxClass) {
        this.enclosingBoxClass = enclosingBoxClass;
        return this;
    }

    public boolean isInStaticClass() {
        return this.enclosingStaticBoxClass != null;
    }

    public DynamicObject getThisStaticClass() {
        return this.enclosingStaticBoxClass;
    }

    public FunctionBoxContext setThisStaticClass(DynamicObject enclosingStaticBoxClass) {
        this.enclosingStaticBoxClass = enclosingStaticBoxClass;
        return this;
    }

    public boolean isInInterface() {
        return this.enclosingBoxInterface != null;
    }

    public BoxInterface getThisInterface() {
        return this.enclosingBoxInterface;
    }

    public FunctionBoxContext setThisInterface(BoxInterface enclosingBoxInterface) {
        this.enclosingBoxInterface = enclosingBoxInterface;
        return this;
    }

    @Override
    public FunctionBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        super.flushBuffer(force);
        return this;
    }

    @Override
    public Object invokeFunction(Key name, Object[] positionalArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, positionalArguments, false, name);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.isInClass() && this.getThisClass().getVariablesScope().containsKey(Key.onMissingMethod)) {
                return this.getThisClass().getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope((IBoxContext)this, positionalArguments)}, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, positionalArguments);
    }

    @Override
    public Object invokeFunction(Key name, Map<Key, Object> namedArguments) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke((IBoxContext)this, namedArguments, false, name);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.isInClass() && this.getThisClass().getVariablesScope().containsKey(Key.onMissingMethod)) {
                HashMap<Key, Object> args = new HashMap<Key, Object>();
                args.put(Key.missingMethodName, name.getName());
                args.put(Key.missingMethodArguments, ArgumentUtil.createArgumentsScope((IBoxContext)this, namedArguments));
                return this.getThisClass().getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, args, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, namedArguments);
    }

    @Override
    public Object invokeFunction(Key name) {
        BIFDescriptor bif = this.findBIF(name);
        if (bif != null) {
            return bif.invoke(this, false);
        }
        Function function = this.findFunction(name);
        if (function == null) {
            if (this.isInClass() && this.getThisClass().getVariablesScope().containsKey(Key.onMissingMethod)) {
                return this.getThisClass().getVariablesScope().dereferenceAndInvoke((IBoxContext)this, Key.onMissingMethod, new Object[]{name.getName(), ArgumentUtil.createArgumentsScope((IBoxContext)this, new Object[0])}, (Boolean)false);
            }
            throw new BoxRuntimeException("Function [" + String.valueOf(name) + "] not found");
        }
        return this.invokeFunction(function, name, new Object[0]);
    }

    @Override
    protected Function findFunction(Key name) {
        Object staticResult;
        IBoxContext.ScopeSearchResult result = null;
        try {
            result = this.scopeFindNearby(name, null);
        }
        catch (KeyNotFoundException keyNotFoundException) {
            // empty catch block
        }
        if (result != null) {
            Object value = result.value();
            if (value instanceof Function) {
                Function fun = (Function)value;
                return fun;
            }
            if (value == null) {
                throw new BoxRuntimeException("Variable '" + String.valueOf(name) + "' is null and cannot be used as a function.");
            }
            throw new BoxRuntimeException("Variable '" + String.valueOf(name) + "' of type  '" + value.getClass().getName() + "'  is not a function.");
        }
        if (this.isInInterface() && (staticResult = this.getThisInterface().dereference(this, name, true)) != null && staticResult instanceof Function) {
            Function fun = (Function)staticResult;
            return fun;
        }
        if (this.isInStaticClass() && (staticResult = BoxClassSupport.dereferenceStatic(this.getThisStaticClass(), (IBoxContext)this, name, (Boolean)true)) != null && staticResult instanceof Function) {
            Function fun = (Function)staticResult;
            return fun;
        }
        if (this.isInClass() && (staticResult = this.getThisClass().getStaticScope().get(name)) != null && staticResult instanceof Function) {
            Function fun = (Function)staticResult;
            return fun;
        }
        return null;
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        if (this.isInClass()) {
            IClassRunnable boxClass = this.getThisClass();
            if (udf.hasModifier(BoxMethodDeclarationModifier.STATIC)) {
                this.registerUDF(boxClass.getStaticScope(), udf, override);
                return;
            }
            this.registerUDF(boxClass.getVariablesScope(), udf, override);
        } else {
            this.getParent().registerUDF(udf, override);
        }
    }

    @Override
    public Boolean canOutput() {
        return this.getFunction().canOutput(this);
    }

    @Override
    public IClassRunnable getFunctionClass() {
        return this.isInClass() ? this.getThisClass().getBottomClass() : null;
    }

    @Override
    public BoxInterface getFunctionInterface() {
        return this.isInInterface() ? this.getThisInterface() : null;
    }

    public ArgumentsScope getArgumentsScope() {
        return this.argumentsScope;
    }
}

