/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.compiler.ast.statement.BoxMethodDeclarationModifier;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class InterfaceBoxContext
extends BaseBoxContext {
    protected BoxInterface thisInterface;
    protected StaticScope staticScope;

    public InterfaceBoxContext(IBoxContext parent, BoxInterface thisInterface) {
        super(parent);
        this.thisInterface = thisInterface;
        this.staticScope = thisInterface.getStaticScope();
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(StaticScope.name, (Object)this.staticScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (key.equals(StaticScope.name)) {
            return new IBoxContext.ScopeSearchResult(this.staticScope, this.staticScope, key, true);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.staticScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.staticScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(StaticScope.name)) {
            return this.staticScope;
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        if (udf.hasModifier(BoxMethodDeclarationModifier.STATIC)) {
            this.registerUDF(this.staticScope, udf, override);
        } else if (override || !this.thisInterface.getDefaultMethods().containsKey(udf.getName())) {
            Function f;
            Function function = this.thisInterface.getDefaultMethods().get(udf.getName());
            if (function instanceof Function && (f = function).hasModifier(BoxMethodDeclarationModifier.FINAL)) {
                throw new BoxRuntimeException("Cannot override final method " + String.valueOf(udf.getName()));
            }
            this.thisInterface.getDefaultMethods().put(udf.getName(), udf);
        }
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.staticScope;
    }

    @Override
    public IBoxContext getFunctionParentContext() {
        return this;
    }
}

