/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.util.Map;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.LocalScope;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Lambda;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class LambdaBoxContext
extends FunctionBoxContext {
    public LambdaBoxContext(IBoxContext parent, Lambda function) {
        this(parent, function, new ArgumentsScope());
    }

    public LambdaBoxContext(IBoxContext parent, Lambda function, ArgumentsScope argumentsScope) {
        this(parent, function, function.getName(), argumentsScope);
    }

    public LambdaBoxContext(IBoxContext parent, Lambda function, Key functionCalledName, Object[] positionalArguments) {
        super(parent, (Function)function, functionCalledName, positionalArguments, null);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for LambdaBoxContext");
        }
    }

    public LambdaBoxContext(IBoxContext parent, Lambda function, Key functionCalledName, Map<Key, Object> namedArguments) {
        super(parent, (Function)function, functionCalledName, namedArguments, null);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for LambdaBoxContext");
        }
    }

    public LambdaBoxContext(IBoxContext parent, Lambda function, Key functionCalledName, ArgumentsScope argumentsScope) {
        super(parent, function, functionCalledName, argumentsScope);
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for LambdaBoxContext");
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (!nearby) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(ArgumentsScope.name, (Object)this.argumentsScope);
            scopes.getAsStruct(Key.contextual).put(LocalScope.name, (Object)this.localScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (key.equals(this.localScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.localScope, this.localScope, key, true);
        }
        if (key.equals(this.argumentsScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, this.argumentsScope, key, true);
        }
        Object result = this.localScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.localScope, Struct.unWrapNull(result), key);
        }
        result = this.argumentsScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.argumentsScope, Struct.unWrapNull(result), key);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        if (shallow) {
            return null;
        }
        throw new KeyNotFoundException(String.format("The requested key [%s] was not located in any scope or it's undefined", key.getName()));
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.localScope.getName())) {
            return this.localScope;
        }
        if (name.equals(this.argumentsScope.getName())) {
            return this.argumentsScope;
        }
        if (shallow) {
            return null;
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public Lambda getFunction() {
        return (Lambda)this.function;
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.localScope;
    }
}

