/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.io.PrintStream;
import java.net.URI;
import java.time.ZoneId;
import java.util.ArrayDeque;
import java.util.Locale;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.ApplicationDefaultListener;
import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.loader.DynamicClassLoader;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.ThreadScope;
import ortus.boxlang.runtime.services.ApplicationService;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.util.RequestThreadManager;

public abstract class RequestBoxContext
extends BaseBoxContext
implements IJDBCCapableContext {
    private static final ThreadLocal<ArrayDeque<RequestBoxContext>> current = new ThreadLocal();
    private Locale locale = null;
    private ZoneId timezone = null;
    private RequestThreadManager threadManager = null;
    private DynamicClassLoader requestClassLoader = null;
    private boolean enforceExplicitOutput = false;
    private boolean showDebugOutput = this.getRuntime().inDebugMode();
    private Long requestTimeout = null;
    private DateTime requestStart = new DateTime();
    private ConnectionManager connectionManager;
    private BaseApplicationListener applicationListener;
    private ApplicationService applicationService = this.getRuntime().getApplicationService();
    private PrintStream out = System.out;

    protected RequestBoxContext(IBoxContext parent) {
        super(parent);
        this.connectionManager = new ConnectionManager(this);
    }

    public RequestBoxContext setOut(PrintStream out) {
        this.out = out;
        return this;
    }

    public PrintStream getOut() {
        return this.out;
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.threadManager != null && this.threadManager.hasThreads()) {
            scopes.getAsStruct(Key.contextual).put(ThreadScope.name, (Object)this.threadManager.getThreadScope());
            for (Key threadName : this.threadManager.getThreadNames()) {
                scopes.getAsStruct(Key.contextual).put(threadName, (Object)this.threadManager.getThreadMeta(threadName));
            }
        }
        return super.getVisibleScopes(scopes, nearby, shallow);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (this.threadManager != null && this.threadManager.hasThreads()) {
            if (key.equals(ThreadScope.name)) {
                return new IBoxContext.ScopeSearchResult(this.threadManager.getThreadScope(), this.threadManager.getThreadScope(), key, true);
            }
            IStruct threadMeta = this.threadManager.getThreadMeta(key);
            if (threadMeta != null) {
                return new IBoxContext.ScopeSearchResult(threadMeta, threadMeta, key, true);
            }
        }
        if (this.parent != null) {
            return this.parent.scopeFind(key, defaultScope);
        }
        if (defaultScope != null) {
            return new IBoxContext.ScopeSearchResult(defaultScope, null, key);
        }
        throw new KeyNotFoundException(String.format("The requested key [%s] was not located in any scope or it's undefined", key.getName()));
    }

    public void loadApplicationDescriptor(URI template) {
        this.applicationListener = this.applicationService.createApplicationListener(this, template);
    }

    public abstract Key getSessionID();

    public abstract void resetSession();

    public BaseApplicationListener getApplicationListener() {
        if (this.applicationListener == null) {
            this.applicationListener = new ApplicationDefaultListener(this);
        }
        return this.applicationListener;
    }

    public DynamicClassLoader getRequestClassLoader() {
        if (this.requestClassLoader != null) {
            return this.requestClassLoader;
        }
        if (this.applicationListener == null) {
            return this.getRuntime().getRuntimeLoader();
        }
        this.requestClassLoader = this.applicationListener.getRequestClassLoader(this);
        return this.requestClassLoader;
    }

    public RequestBoxContext setApplicationListener(BaseApplicationListener applicationListener) {
        this.applicationListener = applicationListener;
        return this;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public RequestBoxContext setLocale(Locale locale) {
        this.locale = locale;
        return this;
    }

    public ZoneId getTimezone() {
        return this.timezone;
    }

    public RequestBoxContext setTimezone(ZoneId timezone) {
        this.timezone = timezone;
        return this;
    }

    @Override
    public IStruct getConfig() {
        IStruct mappings;
        IStruct datasources;
        Object castedDSN;
        IStruct config = super.getConfig();
        if (this.locale != null) {
            config.put(Key.locale, (Object)this.locale);
        }
        if (this.timezone != null) {
            config.put(Key.timezone, (Object)this.timezone);
        }
        if (this.requestTimeout != null) {
            config.put(Key.requestTimeout, (Object)this.requestTimeout);
        }
        config.put(Key.enforceExplicitOutput, (Object)this.enforceExplicitOutput);
        IStruct appSettings = this.getApplicationListener().getSettings();
        config.put(Key.applicationSettings, (Object)appSettings);
        Object v = appSettings.get(Key.datasource);
        if (v instanceof String && ((String)(castedDSN = (String)v)).length() > 0) {
            config.put(Key.defaultDatasource, castedDSN);
        }
        if ((v = appSettings.get(Key.datasource)) instanceof IStruct) {
            castedDSN = (IStruct)v;
            config.getAsStruct(Key.datasources).put(Key.bxDefaultDatasource, castedDSN);
            config.put(Key.defaultDatasource, (Object)Key.bxDefaultDatasource.getName());
        }
        if (!(datasources = appSettings.getAsStruct(Key.datasources)).isEmpty()) {
            config.getAsStruct(Key.datasources).putAll(datasources);
        }
        if (!(mappings = appSettings.getAsStruct(Key.mappings)).isEmpty()) {
            config.getAsStruct(Key.mappings).putAll(mappings);
        }
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_REQUEST_CONTEXT_CONFIG, Struct.of(new Object[]{"context", this, "config", config}));
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestThreadManager getThreadManager() {
        if (this.threadManager != null) {
            return this.threadManager;
        }
        RequestBoxContext requestBoxContext = this;
        synchronized (requestBoxContext) {
            if (this.threadManager != null) {
                return this.threadManager;
            }
            this.threadManager = new RequestThreadManager();
        }
        return this.threadManager;
    }

    public RequestBoxContext setEnforceExplicitOutput(boolean enforceExplicitOutput) {
        this.enforceExplicitOutput = enforceExplicitOutput;
        return this;
    }

    public boolean isEnforceExplicitOutput() {
        return this.enforceExplicitOutput;
    }

    public RequestBoxContext setRequestTimeout(Long requestTimeout) {
        this.requestTimeout = requestTimeout;
        return this;
    }

    public Long getRequestTimeout() {
        return this.requestTimeout;
    }

    public IStruct getSettings() {
        return this.getApplicationListener().getSettings();
    }

    public DateTime getRequestStart() {
        return this.requestStart;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void shutdownConnections() {
        this.connectionManager.shutdown();
    }

    public RequestBoxContext setShowDebugOutput(boolean showDebugOutput) {
        this.showDebugOutput = showDebugOutput;
        return this;
    }

    public boolean isShowDebugOutput() {
        return this.showDebugOutput;
    }

    public static RequestBoxContext getCurrent() {
        ArrayDeque<RequestBoxContext> stack = current.get();
        if (stack == null || stack.isEmpty()) {
            return null;
        }
        return stack.peek();
    }

    public static void setCurrent(RequestBoxContext context) {
        ArrayDeque<RequestBoxContext> stack = current.get();
        if (stack == null) {
            stack = new ArrayDeque();
            current.set(stack);
        }
        stack.push(context);
    }

    public static void removeCurrent() {
        ArrayDeque<RequestBoxContext> stack = current.get();
        if (stack != null) {
            stack.pop();
            if (stack.isEmpty()) {
                current.remove();
            }
        }
    }
}

