/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.Configuration;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.ServerScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class RuntimeBoxContext
extends BaseBoxContext {
    private static final Logger logger = LoggerFactory.getLogger(ServerScope.class);
    protected IScope serverScope = new ServerScope();
    private BoxRuntime runtime = BoxRuntime.getInstance();
    private Configuration runtimeConfig = this.runtime.getConfiguration();

    public RuntimeBoxContext(IBoxContext parent) {
        super(parent);
    }

    public RuntimeBoxContext() {
        this(null);
    }

    @Override
    public void startup() {
        this.serverScope.initialize();
        BoxRuntime.getInstance().announce(BoxEvent.ON_RUNTIME_BOX_CONTEXT_STARTUP, Struct.of(new Object[]{"context", this, "configuration", this.runtimeConfig, "serverScope", this.serverScope}));
        logger.debug("Runtime Box Context started");
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        scopes.getAsStruct(Key.contextual).put(ServerScope.name, (Object)this.serverScope);
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (this.parent != null) {
            return this.parent.scopeFind(key, defaultScope);
        }
        if (defaultScope != null) {
            return new IBoxContext.ScopeSearchResult(defaultScope, null, key);
        }
        throw new KeyNotFoundException(String.format("The requested key [%s] was not located in any scope or it's undefined", key.getName()));
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals(this.serverScope.getName())) {
            return this.serverScope;
        }
        if (this.parent != null) {
            return this.parent.getScope(name);
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.serverScope, udf, override);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.serverScope;
    }

    @Override
    public IStruct getConfig() {
        return this.runtimeConfig.asStruct();
    }
}

