/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import java.net.URI;
import java.util.Iterator;
import java.util.UUID;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.application.BaseApplicationListener;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.RequestBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.RequestScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class ScriptingRequestBoxContext
extends RequestBoxContext {
    private static BoxRuntime runtime = BoxRuntime.getInstance();
    protected IScope variablesScope = new VariablesScope();
    protected IScope requestScope = new RequestScope();
    private Key sessionID = new Key(UUID.randomUUID().toString());

    public ScriptingRequestBoxContext(IBoxContext parent) {
        super(parent);
        this.loadApplicationDescriptor(null);
    }

    public ScriptingRequestBoxContext(IBoxContext parent, BaseApplicationListener listener) {
        super(parent);
        this.setApplicationListener(listener);
    }

    public ScriptingRequestBoxContext(IBoxContext parent, URI template) {
        super(parent);
        this.loadApplicationDescriptor(template);
    }

    public ScriptingRequestBoxContext(URI template) {
        super(null);
        this.loadApplicationDescriptor(template);
    }

    public ScriptingRequestBoxContext() {
        this(runtime.getRuntimeContext(), (URI)null);
    }

    @Override
    public Key getSessionID() {
        return this.sessionID;
    }

    @Override
    public void resetSession() {
        this.sessionID = new Key(UUID.randomUUID().toString());
        this.getApplicationListener().invalidateSession(this.sessionID);
    }

    public void setSessionID(Key sessionID) {
        this.sessionID = sessionID;
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (!shallow) {
            scopes.getAsStruct(Key.contextual).put(RequestScope.name, (Object)this.requestScope);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
        }
        return super.getVisibleScopes(scopes, nearby, shallow);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        Object result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return super.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals(this.requestScope.getName())) {
            return this.requestScope;
        }
        if (this.parent != null) {
            return this.parent.getScope(name);
        }
        throw new ScopeNotFoundException(String.format("The requested scope name [%s] was not located in any context", name.getName()));
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(this.variablesScope.getName())) {
            return this.variablesScope;
        }
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.variablesScope;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        if (this.hasParent().booleanValue() && this.buffers.size() == 1) {
            String output;
            StringBuffer buffer;
            StringBuffer stringBuffer = buffer = this.getBuffer();
            synchronized (stringBuffer) {
                output = buffer.toString();
                this.clearBuffer();
            }
            IStruct eventData = Struct.of(new Object[]{Key.context, this, Key.output, output});
            BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_REQUEST_FLUSH_BUFFER, eventData);
            this.getOut().print(eventData.getAsString(Key.output));
        } else if (force) {
            Iterator iterator = this.buffers.iterator();
            while (iterator.hasNext()) {
                String output;
                StringBuffer buf;
                StringBuffer stringBuffer = buf = (StringBuffer)iterator.next();
                synchronized (stringBuffer) {
                    output = buf.toString();
                    buf.setLength(0);
                }
                IStruct eventData = Struct.of(new Object[]{Key.context, this, Key.output, output});
                BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_REQUEST_FLUSH_BUFFER, eventData);
                this.getOut().print(eventData.getAsString(Key.output));
            }
        }
        return this;
    }
}

