/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.application.Session;
import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.SessionScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class SessionBoxContext
extends BaseBoxContext {
    protected Session session;
    protected IScope sessionScope;

    public SessionBoxContext(Session session) {
        super(null);
        this.session = session;
        this.sessionScope = session.getSessionScope();
    }

    public Session getSession() {
        return this.session;
    }

    public SessionBoxContext updateSession(Session session) {
        this.session = session;
        this.sessionScope = session.getSessionScope();
        return this;
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        scopes.getAsStruct(Key.contextual).put(SessionScope.name, (Object)this.sessionScope);
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        if (key.equals(this.sessionScope.getName())) {
            return new IBoxContext.ScopeSearchResult(this.sessionScope, this.sessionScope, key, true);
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        if (name.equals(this.sessionScope.getName())) {
            return this.sessionScope;
        }
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (shallow) {
            return null;
        }
        return this.getScope(name);
    }
}

