/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.StaticScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class StaticClassBoxContext
extends BaseBoxContext {
    protected IScope staticScope;
    protected DynamicObject staticBoxClass = null;

    public StaticClassBoxContext(IBoxContext parent, DynamicObject staticBoxClass, StaticScope staticScope) {
        super(parent);
        this.staticBoxClass = staticBoxClass;
        this.staticScope = staticScope;
        if (parent == null) {
            throw new BoxRuntimeException("Parent context cannot be null for StaticClassBoxContext");
        }
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            scopes.getAsStruct(Key.contextual).put(StaticScope.name, (Object)this.staticScope);
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        if (key.equals(ThisScope.name)) {
            throw new BoxRuntimeException("Cannot access this scope in a static context");
        }
        if (key.equals(StaticScope.name)) {
            return new IBoxContext.ScopeSearchResult(this.staticScope, this.staticScope, key, true);
        }
        if (key.equals(Key._super)) {
            throw new BoxRuntimeException("Cannot access super scope in a static context");
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        if (shallow) {
            return null;
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        if (name.equals(VariablesScope.name)) {
            throw new BoxRuntimeException("Cannot access variables scope in a static context");
        }
        if (name.equals(StaticScope.name)) {
            return this.staticScope;
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.staticScope;
    }

    @Override
    public IBoxContext getFunctionParentContext() {
        return this;
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.staticScope, udf, override);
    }

    @Override
    public IBoxContext flushBuffer(boolean force) {
        if (!this.canOutput().booleanValue() && !force) {
            return this;
        }
        super.flushBuffer(force);
        return this;
    }

    @Override
    public Boolean canOutput() {
        return BoxClassSupport.canOutput(this, this.staticBoxClass);
    }
}

