/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.context;

import ortus.boxlang.runtime.context.BaseBoxContext;
import ortus.boxlang.runtime.context.ClassBoxContext;
import ortus.boxlang.runtime.context.FunctionBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.context.IJDBCCapableContext;
import ortus.boxlang.runtime.jdbc.ConnectionManager;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.LocalScope;
import ortus.boxlang.runtime.scopes.ThisScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.UDF;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;
import ortus.boxlang.runtime.util.RequestThreadManager;

public class ThreadBoxContext
extends BaseBoxContext
implements IJDBCCapableContext {
    protected IScope localScope;
    protected IScope variablesScope;
    protected Thread thread;
    protected Key threadName;
    private RequestThreadManager threadManager;
    private ConnectionManager connectionManager;

    public ThreadBoxContext(IBoxContext parent, RequestThreadManager threadManager, Key threadName) {
        super(parent);
        this.threadManager = threadManager;
        this.threadName = threadName;
        this.connectionManager = new ConnectionManager(this);
        this.localScope = new LocalScope();
        this.variablesScope = parent.getScopeNearby(VariablesScope.name);
    }

    public ThreadBoxContext setThread(Thread thread) {
        this.thread = thread;
        return this;
    }

    @Override
    public IStruct getVisibleScopes(IStruct scopes, boolean nearby, boolean shallow) {
        if (this.hasParent().booleanValue() && !shallow) {
            this.getParent().getVisibleScopes(scopes, false, false);
        }
        if (nearby) {
            ClassBoxContext cbc;
            FunctionBoxContext fbc;
            scopes.getAsStruct(Key.contextual).put(LocalScope.name, (Object)this.localScope);
            scopes.getAsStruct(Key.contextual).put(Key.thread, (Object)this.threadManager.getThreadMeta(this.threadName));
            scopes.getAsStruct(Key.contextual).put(VariablesScope.name, (Object)this.variablesScope);
            IBoxContext iBoxContext = this.getParent();
            if (iBoxContext instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass()) {
                scopes.getAsStruct(Key.contextual).put(ThisScope.name, (Object)fbc.getThisClass().getThisScope());
            }
            if ((iBoxContext = this.getParent()) instanceof ClassBoxContext) {
                cbc = (ClassBoxContext)iBoxContext;
                scopes.getAsStruct(Key.contextual).put(ThisScope.name, (Object)cbc.getThisScope());
            }
            if ((iBoxContext = this.getParent()) instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass() && fbc.getThisClass().getSuper() != null) {
                scopes.getAsStruct(Key.contextual).put(Key._super, (Object)fbc.getThisClass().getSuper().getVariablesScope());
            }
            if ((iBoxContext = this.getParent()) instanceof ClassBoxContext && (cbc = (ClassBoxContext)iBoxContext).getThisClass().getSuper() != null) {
                scopes.getAsStruct(Key.contextual).put(Key._super, (Object)cbc.getThisClass().getSuper().getVariablesScope());
            }
        }
        return scopes;
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFindNearby(Key key, IScope defaultScope, boolean shallow) {
        Object result = this.localScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.localScope, Struct.unWrapNull(result), key);
        }
        result = this.variablesScope.getRaw(key);
        if (result != null) {
            return new IBoxContext.ScopeSearchResult(this.variablesScope, Struct.unWrapNull(result), key);
        }
        IBoxContext.ScopeSearchResult querySearch = this.queryFindNearby(key);
        if (querySearch != null) {
            return querySearch;
        }
        if (shallow) {
            return null;
        }
        return this.scopeFind(key, defaultScope);
    }

    @Override
    public IBoxContext.ScopeSearchResult scopeFind(Key key, IScope defaultScope) {
        Object result;
        IBoxContext.ScopeSearchResult parentSearchResult;
        IStruct threadMeta = this.threadManager.getThreadMeta(this.threadName);
        if (key.equals(Key.thread)) {
            return new IBoxContext.ScopeSearchResult(threadMeta, threadMeta, key, true);
        }
        if (key.equals(this.threadName)) {
            return new IBoxContext.ScopeSearchResult(threadMeta, threadMeta, key, true);
        }
        IBoxContext iBoxContext = this.getParent();
        if (iBoxContext instanceof FunctionBoxContext) {
            FunctionBoxContext fbc = (FunctionBoxContext)iBoxContext;
            parentSearchResult = fbc.scopeFindThis(key);
            if (parentSearchResult != null) {
                return parentSearchResult;
            }
            parentSearchResult = fbc.scopeFindSuper(key);
            if (parentSearchResult != null) {
                return parentSearchResult;
            }
        }
        if ((iBoxContext = this.getParent()) instanceof ClassBoxContext) {
            ClassBoxContext cbc = (ClassBoxContext)iBoxContext;
            parentSearchResult = cbc.scopeFindThis(key);
            if (parentSearchResult != null) {
                return parentSearchResult;
            }
            parentSearchResult = cbc.scopeFindSuper(key);
            if (parentSearchResult != null) {
                return parentSearchResult;
            }
        }
        if ((result = threadMeta.getRaw(key)) != null) {
            return new IBoxContext.ScopeSearchResult(threadMeta, Struct.unWrapNull(result), key);
        }
        return this.parent.scopeFind(key, defaultScope);
    }

    @Override
    public IScope getScope(Key name) throws ScopeNotFoundException {
        return this.parent.getScope(name);
    }

    @Override
    public IScope getScopeNearby(Key name, boolean shallow) throws ScopeNotFoundException {
        ClassBoxContext cbc;
        FunctionBoxContext fbc;
        IBoxContext iBoxContext;
        if (name.equals(this.localScope.getName())) {
            return this.localScope;
        }
        if (name.equals(VariablesScope.name)) {
            return this.variablesScope;
        }
        if (name.equals(ThisScope.name)) {
            iBoxContext = this.getParent();
            if (iBoxContext instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass()) {
                return fbc.getThisClass().getThisScope();
            }
            iBoxContext = this.getParent();
            if (iBoxContext instanceof ClassBoxContext) {
                cbc = (ClassBoxContext)iBoxContext;
                return cbc.getThisScope();
            }
        }
        if (name.equals(Key._super)) {
            iBoxContext = this.getParent();
            if (iBoxContext instanceof FunctionBoxContext && (fbc = (FunctionBoxContext)iBoxContext).isInClass() && fbc.getThisClass().getSuper() != null) {
                return fbc.getThisClass().getSuper().getVariablesScope();
            }
            iBoxContext = this.getParent();
            if (iBoxContext instanceof ClassBoxContext && (cbc = (ClassBoxContext)iBoxContext).getThisClass().getSuper() != null) {
                return cbc.getThisClass().getSuper().getVariablesScope();
            }
        }
        if (shallow) {
            return null;
        }
        return this.parent.getScope(name);
    }

    @Override
    public IScope getDefaultAssignmentScope() {
        return this.localScope;
    }

    @Override
    public void registerUDF(UDF udf, boolean override) {
        this.registerUDF(this.variablesScope, udf, override);
    }

    public Thread getThread() {
        return this.thread;
    }

    @Override
    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    @Override
    public void shutdownConnections() {
        this.connectionManager.shutdown();
    }
}

