/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic;

import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.CustomException;
import ortus.boxlang.runtime.types.exceptions.NoElementException;
import ortus.boxlang.runtime.util.ValidationUtil;

public class Attempt<T> {
    protected static final Attempt<?> EMPTY = new Attempt();
    protected final T value;
    protected ValidationRecord validationRecord;
    protected Boolean simpleEval = false;

    protected Attempt() {
        this(null);
    }

    protected Attempt(T value) {
        this.value = value;
        this.validationRecord = new ValidationRecord();
    }

    public static <T> Attempt<T> of(T value) {
        return new Attempt<T>(value);
    }

    public static <T> Attempt<T> empty() {
        return EMPTY;
    }

    public Attempt<T> toMatchRegex(String pattern) {
        return this.toMatchRegex(pattern, true);
    }

    public Attempt<T> toMatchRegex(String pattern, Boolean caseSensitive) {
        Objects.requireNonNull(pattern);
        this.validationRecord = new ValidationRecord(pattern, caseSensitive);
        return this;
    }

    public Attempt<T> toBeBetween(Double min, Double max) {
        Objects.requireNonNull(min);
        Objects.requireNonNull(max);
        this.validationRecord = new ValidationRecord(min, max);
        return this;
    }

    public Attempt<T> toBeType(String type) {
        Objects.requireNonNull(type);
        this.validationRecord = new ValidationRecord(type);
        return this;
    }

    public Attempt<T> toSatisfy(Predicate<Object> predicate) {
        Objects.requireNonNull(predicate);
        this.validationRecord = new ValidationRecord(predicate);
        return this;
    }

    public Attempt<T> toBe(Object other) {
        return this.toSatisfy(target -> Objects.equals(target, other));
    }

    public boolean isValid() {
        if (this.isEmpty()) {
            return false;
        }
        if (this.validationRecord.isFunction().booleanValue()) {
            return this.validationRecord.validationFunction.test(this.value);
        }
        if (this.validationRecord.isRange().booleanValue()) {
            return ValidationUtil.isValidRange(this.value, this.validationRecord.min(), this.validationRecord.min());
        }
        if (this.validationRecord.isPattern().booleanValue()) {
            if (this.validationRecord.caseSensitive().booleanValue()) {
                return ValidationUtil.isValidMatch(StringCaster.cast(this.value), this.validationRecord.pattern());
            }
            return ValidationUtil.isValidMatchNoCase(StringCaster.cast(this.value), this.validationRecord.pattern());
        }
        if (this.validationRecord.isType().booleanValue()) {
            return (Boolean)BoxRuntime.getInstance().getFunctionService().getGlobalFunction(Key.isValid).invoke(BoxRuntime.getInstance().getRuntimeContext(), new Object[]{this.validationRecord.type, this.value}, false, Key.isValid);
        }
        return false;
    }

    public Attempt<T> ifValid(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.isValid()) {
            action.accept(this.value);
        }
        return this;
    }

    public Attempt<T> ifInvalid(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (!this.isValid()) {
            action.accept(this.value);
        }
        return this;
    }

    public T get() {
        if (this.isPresent()) {
            return this.value;
        }
        throw new NoElementException("Attempt is empty");
    }

    public T getOrFail() {
        return this.get();
    }

    public boolean isEmpty() {
        return !this.isPresent();
    }

    public boolean isNull() {
        return this.value == null;
    }

    public boolean ifFailed() {
        return this.isEmpty();
    }

    public boolean wasSuccessful() {
        return this.isPresent();
    }

    public boolean isPresent() {
        if (this.value == null) {
            return false;
        }
        if (this.simpleEval.booleanValue()) {
            return true;
        }
        CastAttempt<Boolean> castAttempt = BooleanCaster.attempt(this.value);
        if (castAttempt.wasSuccessful()) {
            return castAttempt.get();
        }
        return true;
    }

    public Attempt<T> ifPresent(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        if (this.isPresent()) {
            action.accept(this.value);
        }
        return this;
    }

    public Attempt<T> ifSuccessful(Consumer<? super T> action) {
        return this.ifPresent(action);
    }

    public Attempt<T> ifPresentOrElse(Consumer<? super T> action, Runnable emptyAction) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(emptyAction);
        if (this.isPresent()) {
            action.accept(this.value);
        } else {
            emptyAction.run();
        }
        return this;
    }

    public Attempt<T> ifEmpty(Runnable consumer) {
        Objects.requireNonNull(consumer);
        if (this.isEmpty()) {
            consumer.run();
        }
        return this;
    }

    public Attempt<T> or(Supplier<Attempt<T>> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isEmpty()) {
            return supplier.get();
        }
        return this;
    }

    public T orElse(T other) {
        if (this.isEmpty()) {
            return other;
        }
        return this.value;
    }

    public T getOrDefault(T other) {
        return this.orElse(other);
    }

    public T orElseGet(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier);
        if (this.isEmpty()) {
            return supplier.get();
        }
        return this.value;
    }

    public T getOrSupply(Supplier<? extends T> other) {
        return this.orElseGet(other);
    }

    public <U> Attempt<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Attempt.empty();
        }
        return Attempt.of(mapper.apply(this.value));
    }

    public <U> Attempt<U> flatMap(Function<? super T, ? extends Attempt<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return Attempt.empty();
        }
        Attempt<? extends U> r = mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }

    public T orThrow() {
        return this.orThrow("Attempt is empty");
    }

    public T orThrow(String type, String message) {
        if (this.isEmpty()) {
            this.orThrow(new CustomException(message, "", "", type, new Struct(), null));
        }
        return this.value;
    }

    public T orThrow(String message) {
        if (this.isEmpty()) {
            throw new NoElementException(message);
        }
        return this.value;
    }

    public T orThrow(Exception throwable) {
        if (this.isEmpty()) {
            try {
                throw throwable;
            }
            catch (Exception e) {
                throw new BoxRuntimeException("Can't throw exception", e);
            }
        }
        return this.value;
    }

    public Stream<T> stream() {
        return this.isEmpty() ? Stream.empty() : Stream.of(this.value);
    }

    public String toString() {
        return this.isEmpty() ? "Attempt.empty" : String.format("Attempt[%s]", this.value.toString());
    }

    public int hashCode() {
        return this.isEmpty() ? 0 : Objects.hashCode(this.value);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj instanceof Attempt) {
            Attempt castedAttempt = (Attempt)obj;
            if (this.isEmpty() && castedAttempt.isEmpty()) {
                return true;
            }
            if (this.isEmpty() || castedAttempt.isEmpty()) {
                return false;
            }
            return this.get().equals(castedAttempt.get());
        }
        if (this.isEmpty() && obj == null) {
            return true;
        }
        if (this.isEmpty() && obj != null) {
            return false;
        }
        return this.get().equals(obj);
    }

    public Attempt<T> filter(Predicate<? super T> predicate) {
        if (this.isEmpty()) {
            return Attempt.empty();
        }
        if (predicate.test(this.value)) {
            return this;
        }
        return Attempt.empty();
    }

    public Attempt<T> setSimpleEval(Boolean eval) {
        this.simpleEval = eval;
        return this;
    }

    private record ValidationRecord(String type, Double min, Double max, String pattern, Boolean caseSensitive, Predicate<Object> validationFunction) {
        public ValidationRecord() {
            this(null, null, null, null, null, null);
        }

        public ValidationRecord(Predicate<Object> validationFunction) {
            this(null, null, null, null, null, validationFunction);
        }

        public ValidationRecord(String type) {
            this(type, null, null, null, null, null);
        }

        public ValidationRecord(Double min, Double max) {
            this(null, min, max, null, null, null);
        }

        public ValidationRecord(String pattern, Boolean caseSensitive) {
            this(null, null, null, pattern, caseSensitive, null);
        }

        public Boolean isFunction() {
            return this.validationFunction != null;
        }

        public Boolean isPattern() {
            return this.pattern != null;
        }

        public Boolean isRange() {
            return this.min != null && this.max != null;
        }

        public Boolean isType() {
            return this.type != null;
        }
    }
}

