/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic;

import java.util.ArrayList;
import java.util.Set;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.Referencer;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.scopes.RequestScope;
import ortus.boxlang.runtime.scopes.ServerScope;
import ortus.boxlang.runtime.scopes.VariablesScope;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExpressionException;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.ScopeNotFoundException;

public class ExpressionInterpreter {
    private static Set<Key> scopes = Set.of(VariablesScope.name, RequestScope.name, ServerScope.name);

    public static Object getVariable(IBoxContext context, String expression, boolean safe) {
        if ((expression = expression.trim()).startsWith("\"") && expression.endsWith("\"")) {
            return expression.substring(1, expression.length() - 1).replace("\"\"", "\"");
        }
        if (expression.startsWith("'") && expression.endsWith("'")) {
            return expression.substring(1, expression.length() - 1).replace("''", "'");
        }
        if (expression.matches("^-?\\d+(\\.\\d+)?$")) {
            return NumberCaster.cast(expression);
        }
        if (expression.equalsIgnoreCase("true")) {
            return true;
        }
        if (expression.equalsIgnoreCase("false")) {
            return false;
        }
        String[] parts2 = ExpressionInterpreter.splitParts(context, expression, safe);
        Object ref = null;
        Key refName = Key.of(parts2[0]);
        if (scopes.contains(refName)) {
            try {
                ref = context.getScopeNearby(refName);
            }
            catch (ScopeNotFoundException e) {
                if (safe) {
                    return null;
                }
                throw e;
            }
        } else {
            ref = context.scopeFindNearby(refName, safe ? context.getDefaultAssignmentScope() : null).value();
            if (ref == null && !safe) {
                throw new KeyNotFoundException("Variable [" + String.valueOf(refName) + "] not found.");
            }
        }
        for (int i = 1; i < parts2.length; ++i) {
            ref = Referencer.get(context, ref, Key.of(parts2[i]), safe);
        }
        return ref;
    }

    public static Object setVariable(IBoxContext context, String expression, Object value) {
        Key[] keys;
        String[] parts2 = ExpressionInterpreter.splitParts(context, expression, false);
        IReferenceable ref = null;
        Key refName = Key.of(parts2[0]);
        if (scopes.contains(refName)) {
            if (parts2.length == 1) {
                throw new BoxRuntimeException("Cannot assign to a scope: [" + expression + "]");
            }
            ref = context.getScopeNearby(refName);
            keys = new Key[parts2.length - 1];
            for (int i = 1; i < parts2.length; ++i) {
                keys[i - 1] = Key.of(parts2[i]);
            }
        } else {
            IBoxContext.ScopeSearchResult scopeSearchResult = context.scopeFindNearby(refName, context.getDefaultAssignmentScope());
            ref = scopeSearchResult.scope();
            if (scopeSearchResult.isScope()) {
                keys = new Key[parts2.length - 1];
                for (int i = 1; i < parts2.length; ++i) {
                    keys[i - 1] = Key.of(parts2[i]);
                }
            } else {
                keys = new Key[parts2.length];
                for (int i = 0; i < parts2.length; ++i) {
                    keys[i] = Key.of(parts2[i]);
                }
            }
        }
        return Referencer.setDeep(context, ref, value, keys);
    }

    private static String[] splitParts(IBoxContext context, String expression, boolean safe) {
        if (expression.isEmpty() || expression.startsWith(".") || expression.endsWith(".") || expression.startsWith("[")) {
            throw new ExpressionException("Invalid expression", null, expression);
        }
        boolean ready = true;
        boolean quote = false;
        char quoteChar = '\u0000';
        boolean bracket = false;
        ArrayList<String> parts2 = new ArrayList<String>();
        StringBuilder part = new StringBuilder();
        for (int i = 0; i < expression.length(); ++i) {
            if (quote) {
                if (expression.charAt(i) == quoteChar) {
                    if (i + 1 < expression.length() && expression.charAt(i + 1) == quoteChar) {
                        part.append(quoteChar);
                        ++i;
                        continue;
                    }
                    quote = false;
                    ready = false;
                    parts2.add(part.toString());
                    part.setLength(0);
                    continue;
                }
                part.append(expression.charAt(i));
                continue;
            }
            if (expression.charAt(i) == '\"' || expression.charAt(i) == '\'') {
                if (part.length() > 0 || !ready) {
                    throw new ExpressionException("Invalid expression, [" + expression.charAt(i) + "] not allowed at position " + (i + 1), null, expression);
                }
                quote = true;
                quoteChar = expression.charAt(i);
                continue;
            }
            if (expression.charAt(i) == '.') {
                if (part.length() > 0) {
                    parts2.add(part.toString());
                    part.setLength(0);
                }
                ready = true;
                continue;
            }
            if (expression.charAt(i) == '[') {
                if (bracket) {
                    throw new ExpressionException("Invalid expression, ([) not allowed at position " + (i + 1), null, expression);
                }
                if (part.length() > 0) {
                    parts2.add(part.toString());
                    part.setLength(0);
                }
                bracket = true;
                ready = true;
                continue;
            }
            if (expression.charAt(i) == ']') {
                if (!bracket) {
                    throw new ExpressionException("Invalid expression, (]) not allowed at position " + (i + 1), null, expression);
                }
                if (part.length() > 0) {
                    parts2.add(part.toString());
                    part.setLength(0);
                }
                bracket = false;
                continue;
            }
            if (Character.isWhitespace(expression.charAt(i))) continue;
            if (!ready) {
                throw new ExpressionException("Invalid expression, [" + expression.charAt(i) + "] not allowed at position " + (i + 1), null, expression);
            }
            if (!Character.isLetterOrDigit(expression.charAt(i)) && expression.charAt(i) != '_' && expression.charAt(i) != '$') continue;
            if (bracket) {
                int end = expression.indexOf(93, i);
                if (end == -1) {
                    throw new ExpressionException("Invalid expression, unclosed bracket", null, expression);
                }
                parts2.add(StringCaster.cast(ExpressionInterpreter.getVariable(context, expression.substring(i, end), safe)));
                i = end - 1;
                continue;
            }
            part.append(expression.charAt(i));
        }
        if (quote) {
            throw new ExpressionException("Invalid expression, unclosed quote", null, expression);
        }
        if (bracket) {
            throw new ExpressionException("Invalid expression, unclosed bracket", null, expression);
        }
        if (part.length() > 0) {
            parts2.add(part.toString());
        }
        return parts2.toArray(new String[0]);
    }
}

