/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic;

import java.util.List;
import java.util.Map;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.IScope;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class Referencer {
    public static Object get(IBoxContext context, Object object, Key key, Boolean safe) {
        if (object == null) {
            if (safe.booleanValue()) {
                return null;
            }
            throw new BoxRuntimeException("Cannot dereference key [" + key.getName() + "] on a null object");
        }
        if (object instanceof DynamicObject) {
            DynamicObject dob = (DynamicObject)object;
            return dob.dereference(context, key, safe);
        }
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return DynamicInteropService.dereference(context, clazz, null, key, safe);
        }
        return DynamicInteropService.dereference(context, object.getClass(), object, key, safe);
    }

    public static Object getAndInvoke(IBoxContext context, Object object, Key key, Object[] positionalArguments, Boolean safe) {
        if (object == null) {
            if (safe.booleanValue()) {
                return null;
            }
            throw new BoxRuntimeException("Cannot invoke method [" + key.getName() + "()] on a null object");
        }
        if (object instanceof DynamicObject) {
            DynamicObject dob = (DynamicObject)object;
            return dob.dereferenceAndInvoke(context, key, positionalArguments, safe);
        }
        return DynamicInteropService.dereferenceAndInvoke(null, object, context, key, positionalArguments, safe);
    }

    public static Object getAndInvoke(IBoxContext context, Object object, Key key, Boolean safe) {
        if (object == null) {
            if (safe.booleanValue()) {
                return null;
            }
            throw new BoxRuntimeException("Cannot invoke method [" + key.getName() + "()] on a null object");
        }
        if (object instanceof DynamicObject) {
            DynamicObject dob = (DynamicObject)object;
            return dob.dereferenceAndInvoke(context, key, new Object[0], safe);
        }
        return DynamicInteropService.dereferenceAndInvoke(null, object, context, key, new Object[0], safe);
    }

    public static Object getAndInvoke(IBoxContext context, Object object, Key key, Map<Key, Object> namedArguments, Boolean safe) {
        if (object == null) {
            if (safe.booleanValue()) {
                return null;
            }
            throw new BoxRuntimeException("Cannot invoke method [" + key.getName() + "()] on a null object");
        }
        if (object instanceof DynamicObject) {
            DynamicObject dob = (DynamicObject)object;
            return dob.dereferenceAndInvoke(context, key, namedArguments, safe);
        }
        return DynamicInteropService.dereferenceAndInvoke(null, object, context, key, namedArguments, safe);
    }

    public static Object set(IBoxContext context, boolean isFinal, Object object, Key key, Object value) {
        if (isFinal) {
            if (object instanceof IClassRunnable) {
                IClassRunnable icr = (IClassRunnable)object;
                object = icr.getThisScope();
            }
            if (object instanceof IScope) {
                IScope scope = (IScope)object;
                return scope.assignFinal(context, key, value);
            }
            throw new BoxRuntimeException("Cannot assign final key [" + key.getName() + "] to an object other than a scope.  Base object was [" + object.getClass().getName() + "]");
        }
        if (object instanceof DynamicObject) {
            DynamicObject dob = (DynamicObject)object;
            return dob.assign(context, key, value);
        }
        if (object instanceof Class) {
            Class clazz = (Class)object;
            return DynamicInteropService.assign(context, clazz, null, key, value);
        }
        return DynamicInteropService.assign(context, object.getClass(), object, key, value);
    }

    public static Object set(IBoxContext context, Object object, Key key, Object value) {
        return Referencer.set(context, false, object, key, value);
    }

    public static Object setDeep(IBoxContext context, boolean isFinal, Key mustBeScopeName, Object object, Object value, Key ... keys) {
        IScope s;
        if (!(mustBeScopeName == null || object instanceof IScope && (s = (IScope)object).getName().equals(mustBeScopeName))) {
            throw new BoxRuntimeException("Scope [" + mustBeScopeName.getName() + "] is not available in this context.");
        }
        for (int i = 0; i <= keys.length - 1; ++i) {
            Key key = keys[i];
            if (i == keys.length - 1) {
                Referencer.set(context, isFinal, object, key, value);
                return value;
            }
            Object next = DynamicObject.unWrap(Referencer.get(context, object, key, true));
            if (next == null) {
                next = new Struct();
                Referencer.set(context, isFinal, object, key, next);
            } else if (!(next instanceof Map || next instanceof List || next instanceof Query || next instanceof QueryColumn)) {
                throw new BoxRuntimeException(String.format("Cannot assign to key [%s] because it is a [%s] and not a Struct,  Array, or Query", key.getName(), next.getClass().getName()));
            }
            object = next;
            isFinal = false;
        }
        return value;
    }

    public static Object setDeep(IBoxContext context, Object object, Object value, Key ... keys) {
        return Referencer.setDeep(context, false, null, object, value, keys);
    }

    public static Object setDeep(IBoxContext context, IBoxContext.ScopeSearchResult scopeSearchResult, Object value, Key ... keys) {
        return Referencer.setDeep(context, false, null, scopeSearchResult.scope(), value, scopeSearchResult.getAssignmentKeys(keys));
    }

    public static Object setDeep(IBoxContext context, boolean isFinal, Key mustBeScopeName, IBoxContext.ScopeSearchResult scopeSearchResult, Object value, Key ... keys) {
        return Referencer.setDeep(context, isFinal, mustBeScopeName, scopeSearchResult.scope(), value, scopeSearchResult.getAssignmentKeys(keys));
    }
}

