/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.types.QueryColumn;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class ArrayCaster
implements IBoxCaster {
    public static CastAttempt<ortus.boxlang.runtime.types.Array> attempt(Object object) {
        return CastAttempt.ofNullable(ArrayCaster.cast(object, false));
    }

    public static ortus.boxlang.runtime.types.Array cast(Object object) {
        return ArrayCaster.cast(object, true);
    }

    public static ortus.boxlang.runtime.types.Array cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Array.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof ortus.boxlang.runtime.types.Array) {
            ortus.boxlang.runtime.types.Array col = (ortus.boxlang.runtime.types.Array)object;
            return col;
        }
        if (object.getClass().isArray()) {
            if (object instanceof Object[]) {
                Object[] array = (Object[])object;
                return ortus.boxlang.runtime.types.Array.of(array);
            }
            int length = Array.getLength(object);
            ortus.boxlang.runtime.types.Array arr = new ortus.boxlang.runtime.types.Array();
            for (int i = 0; i < length; ++i) {
                arr.add(Array.get(object, i));
            }
            return arr;
        }
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{List.class, ArgumentsScope.class, QueryColumn.class}, (Object)object3, n)) {
            case 0: {
                List list = (List)object3;
                return ortus.boxlang.runtime.types.Array.fromList((List)object);
            }
            case 1: {
                ArgumentsScope args = (ArgumentsScope)object3;
                return args.asArray();
            }
            case 2: {
                QueryColumn col = (QueryColumn)object3;
                return col.getColumnDataAsArray();
            }
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a Array.", object.getClass().getName()));
        }
        return null;
    }
}

