/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.util.MathUtil;

public class BigDecimalCaster
implements IBoxCaster {
    public static CastAttempt<BigDecimal> attempt(Object object) {
        return CastAttempt.ofNullable(BigDecimalCaster.cast(object, false));
    }

    public static BigDecimal cast(Object object) {
        return BigDecimalCaster.cast(object, true);
    }

    public static BigDecimal cast(Object object, Boolean fail) {
        String stringValue;
        BigDecimal result;
        if (object == null) {
            return BigDecimal.ZERO;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            return bd;
        }
        if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            return new BigDecimal(bi.toString());
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return new BigDecimal(num.doubleValue(), MathUtil.getMathContext());
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? BigDecimal.ONE : BigDecimal.ZERO;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes")) {
                return BigDecimal.ONE;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no")) {
                return BigDecimal.ZERO;
            }
        }
        if ((result = BigDecimalCaster.parseBigDecimal(stringValue = StringCaster.cast(object, false))) != null) {
            return result;
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a BigDecimal.", object.toString()));
        }
        return null;
    }

    private static BigDecimal parseBigDecimal(String value) {
        if (NumberUtils.isCreatable(value)) {
            try {
                return new BigDecimal(value, MathUtil.getMathContext());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

