/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class BigIntegerCaster
implements IBoxCaster {
    public static CastAttempt<BigInteger> attempt(Object object) {
        return CastAttempt.ofNullable(BigIntegerCaster.cast(object, false));
    }

    public static BigInteger cast(Object object) {
        return BigIntegerCaster.cast(object, true);
    }

    public static BigInteger cast(Object object, Boolean fail) {
        String stringValue;
        BigInteger result;
        if (object == null) {
            return BigInteger.ZERO;
        }
        if (object instanceof BigInteger) {
            BigInteger bd = (BigInteger)object;
            return bd;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            return bd.toBigInteger();
        }
        if (object instanceof Integer) {
            Integer i = (Integer)object;
            return BigInteger.valueOf(i.intValue());
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return BigInteger.valueOf(l);
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return BigInteger.valueOf(num.longValue());
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? BigInteger.ONE : BigInteger.ZERO;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes")) {
                return BigInteger.ONE;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no")) {
                return BigInteger.ZERO;
            }
        }
        if ((result = BigIntegerCaster.parseBigInteger(stringValue = StringCaster.cast(object, false))) != null) {
            return result;
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a BigInteger.", object.toString()));
        }
        return null;
    }

    private static BigInteger parseBigInteger(String value) {
        if (NumberUtils.isCreatable(value)) {
            try {
                return new BigInteger(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

