/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.operators.GreaterThan;
import ortus.boxlang.runtime.operators.LessThan;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class BooleanCaster
implements IBoxCaster {
    private static final IStruct wkt = Struct.of(new Object[]{Key.of("Y"), true, Key.of("N"), false, Key.of("Yes"), true, Key.of("No"), false, Key.of("true"), true, Key.of("false"), false});

    public static CastAttempt<Boolean> attempt(Object object) {
        return CastAttempt.ofNullable(BooleanCaster.cast(object, false));
    }

    public static Boolean cast(Object object) {
        return BooleanCaster.cast(object, true);
    }

    public static Boolean cast(Object object, Boolean fail) {
        return BooleanCaster.cast(object, fail, true);
    }

    public static Boolean cast(Object object, Boolean fail, Boolean loose) {
        if (object == null) {
            return false;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.doubleValue() != 0.0;
        }
        if (object instanceof Character) {
            Character ch = (Character)object;
            return switch (ch.charValue()) {
                case '1', 'T', 'Y', 't', 'y' -> true;
                case '0', 'F', 'N', 'f', 'n' -> false;
                default -> {
                    if (fail.booleanValue()) {
                        throw new BoxCastException(String.format("Character [%s] cannot be cast to a boolean", ch));
                    }
                    yield null;
                }
            };
        }
        if (object instanceof String) {
            String str = (String)object;
            Key aliasKey = Key.of(str.trim());
            if (wkt.containsKey(aliasKey)) {
                return wkt.getAsBoolean(aliasKey);
            }
            CastAttempt<Number> numberAttempt = NumberCaster.attempt(str);
            if (numberAttempt.wasSuccessful()) {
                return GreaterThan.invoke(numberAttempt.get(), 0) != false || LessThan.invoke(numberAttempt.get(), 0) != false;
            }
            if (fail.booleanValue()) {
                throw new BoxCastException(String.format("String [%s] cannot be cast to a boolean", str));
            }
            return null;
        }
        if (loose.booleanValue()) {
            Object object2 = object;
            Objects.requireNonNull(object2);
            Object object3 = object2;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Array.class, List.class, Struct.class, Map.class, Query.class}, (Object)object3, n)) {
                case 0 -> {
                    Array castedArray = (Array)object3;
                    yield !castedArray.isEmpty();
                }
                case 1 -> {
                    List castedList = (List)object3;
                    yield !castedList.isEmpty();
                }
                case 2 -> {
                    Struct castedStruct = (Struct)object3;
                    yield !castedStruct.isEmpty();
                }
                case 3 -> {
                    Map castedMap = (Map)object3;
                    yield !castedMap.isEmpty();
                }
                case 4 -> {
                    Query castedQuery = (Query)object3;
                    yield !castedQuery.isEmpty();
                }
                default -> {
                    if (fail.booleanValue()) {
                        throw new BoxCastException(String.format("Value [%s] cannot be cast to a boolean", object.getClass().getName()));
                    }
                    yield null;
                }
            };
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Value [%s] cannot be cast to a boolean", object.getClass().getName()));
        }
        return null;
    }
}

