/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class ByteCaster
implements IBoxCaster {
    public static CastAttempt<Byte> attempt(Object object) {
        return CastAttempt.ofNullable(ByteCaster.cast(object, false));
    }

    public static Byte cast(Object object) {
        return ByteCaster.cast(object, true);
    }

    public static Byte cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a byte.");
            }
            return null;
        }
        if (object instanceof Byte) {
            Byte b = (Byte)object;
            return b;
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.byteValue();
        }
        CastAttempt<Number> number = NumberCaster.attempt(object);
        if (number.wasSuccessful()) {
            return number.get().byteValue();
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a byte.");
        }
        return null;
    }
}

