/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.util.Objects;
import java.util.function.Function;
import ortus.boxlang.runtime.dynamic.Attempt;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public final class CastAttempt<T>
extends Attempt<T> {
    private static final CastAttempt<?> EMPTY = new CastAttempt();

    private CastAttempt() {
        this.simpleEval = true;
    }

    private CastAttempt(T value) {
        super(Objects.requireNonNull(value));
        this.simpleEval = true;
    }

    public static <T> CastAttempt<T> of(T value) {
        return new CastAttempt<T>(value);
    }

    public static <T> CastAttempt<T> ofNullable(T value) {
        return value == null ? CastAttempt.empty() : CastAttempt.of(value);
    }

    public static <T> CastAttempt<T> empty() {
        return EMPTY;
    }

    @Override
    public T get() {
        if (this.isPresent()) {
            return (T)this.value;
        }
        throw new BoxCastException("The cast was not successful.  You cannot get the value.");
    }

    @Override
    public boolean isPresent() {
        return this.value != null;
    }

    @Override
    public <U> CastAttempt<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return CastAttempt.empty();
        }
        return CastAttempt.of(mapper.apply(this.value));
    }

    @Override
    public <U> CastAttempt<U> flatMap(Function<? super T, ? extends Attempt<? extends U>> mapper) {
        Objects.requireNonNull(mapper);
        if (this.isEmpty()) {
            return CastAttempt.empty();
        }
        CastAttempt r = (CastAttempt)mapper.apply(this.value);
        return Objects.requireNonNull(r);
    }
}

