/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class CharacterCaster
implements IBoxCaster {
    public static CastAttempt<Character> attempt(Object object) {
        return CastAttempt.ofNullable(CharacterCaster.cast(object, false));
    }

    public static Character cast(Object object) {
        return CharacterCaster.cast(object, true);
    }

    public static Character cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a char.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Character) {
            Character chr = (Character)object;
            return chr;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.length() > 0) {
                return Character.valueOf(str.charAt(0));
            }
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast empty string to a char.");
            }
            return null;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return Character.valueOf((char)(bool != false ? 1 : 0));
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return Character.valueOf((char)num.doubleValue());
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a char.", object.getClass().getName()));
        }
        return null;
    }
}

