/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.util.ListUtil;

public class CollectionCaster
implements IBoxCaster {
    public static CastAttempt<Collection<Object>> attempt(Object object) {
        return CastAttempt.ofNullable(CollectionCaster.cast(object, false));
    }

    public static Collection<Object> cast(Object object) {
        return CollectionCaster.cast(object, true);
    }

    public static Collection<Object> cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Collection.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof IStruct) {
            IStruct str = (IStruct)object;
            return str.keySet().stream().map(k -> k.getName()).collect(Collectors.toList());
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return map.keySet();
        }
        if (object instanceof Collection) {
            Collection col = (Collection)object;
            return col;
        }
        if (object.getClass().isArray()) {
            Object[] array = (Object[])object;
            return Arrays.asList(array);
        }
        CastAttempt<String> stringAttempt = StringCaster.attempt(object);
        if (stringAttempt.wasSuccessful()) {
            return ListUtil.asList(stringAttempt.get(), ",");
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a Collection.", object.getClass().getName()));
        }
        return null;
    }
}

