/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.lang.runtime.SwitchBootstraps;
import java.sql.Date;
import java.sql.Timestamp;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Calendar;
import java.util.Objects;
import org.apache.commons.lang3.time.DateUtils;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class DateTimeCaster
implements IBoxCaster {
    private static final String[] COMMON_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "dd MMM yyyy HH:mm:ss", "dd-MMM-yyyy HH:mm:ss", "dd/MM/yyyy HH:mm:ss", "dd.MM.yyyy HH:mm:ss", "yyyy-MM-dd'T'HH:mm:ss.SSSXXX", "yyyy-MM-dd'T'HH:mm:ss.SSS", "yyyy-MM-dd'T'HH:mm:ssZ", "yyyy-MM-dd'T'HH:mm:ssX", "yyyy-MM-dd'T'HH:mm:ss", "yyyyMMddHHmmss", "EEE, dd MMM yyyy", "dd MMM yyyy", "dd-MMM-yyyy", "dd/MMM/yyyy", "dd.MMM.yyyy", "dd MM yyyy", "dd-MM-yyyy", "dd/MM/yyyy", "dd.MM.yyyy", "MMM dd yyyy", "MMM-dd-yyyy", "MMM/dd/yyyy", "MMM.dd.yyyy", "MM dd yyyy", "MM-dd-yyyy", "MM/dd/yyyy", "MM.dd.yyyy", "yyyy-MM-dd", "yyyy/MM/dd", "yyyy.MM.dd", "yyyyMMdd"};

    public static CastAttempt<DateTime> attempt(Object object) {
        return CastAttempt.ofNullable(DateTimeCaster.cast(object, false));
    }

    public static DateTime cast(Object object) {
        return DateTimeCaster.cast(object, true);
    }

    public static DateTime cast(Object object, Boolean fail) {
        return DateTimeCaster.cast(object, fail, ZoneId.systemDefault());
    }

    public static DateTime cast(Object object, Boolean fail, ZoneId timezone) {
        return DateTimeCaster.cast(object, fail, timezone, false);
    }

    public static DateTime cast(Object object, Boolean fail, ZoneId timezone, Boolean clone) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a DateTime.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof DateTime) {
            DateTime targetDateTime = (DateTime)object;
            return clone != false ? targetDateTime.clone() : targetDateTime;
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime targetZonedDateTime = (ZonedDateTime)object;
            return new DateTime(targetZonedDateTime);
        }
        if (object instanceof Calendar) {
            Calendar targetCalendar = (Calendar)object;
            return new DateTime(targetCalendar.toInstant().atZone(timezone));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime targetLocalDateTime = (LocalDateTime)object;
            return new DateTime(targetLocalDateTime.atZone(timezone));
        }
        if (object instanceof LocalDate) {
            LocalDate targetLocalDate = (LocalDate)object;
            return new DateTime(targetLocalDate.atStartOfDay(timezone));
        }
        if (object instanceof Date) {
            Date sDate = (Date)object;
            return new DateTime(sDate);
        }
        if (object instanceof java.util.Date) {
            java.util.Date targetDate = (java.util.Date)object;
            return new DateTime(targetDate.toInstant().atZone(timezone));
        }
        if (object instanceof Timestamp) {
            Timestamp targetTimestamp = (Timestamp)object;
            return new DateTime(targetTimestamp.toInstant().atZone(timezone));
        }
        if (object instanceof LocalTime) {
            LocalTime targetTimestamp = (LocalTime)object;
            return new DateTime(targetTimestamp);
        }
        String targetString = StringCaster.attempt(object).getOrDefault(null);
        if (targetString == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast [" + object.toString() + "] to a String.");
            }
            return null;
        }
        try {
            if (targetString.matches("^\\{ts ([^\\}]*)\\}")) {
                return new DateTime(LocalDateTime.parse(targetString.trim(), (DateTimeFormatter)DateTime.COMMON_FORMATTERS.get("ODBCDateTime")));
            }
        }
        catch (Throwable e2) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast [" + targetString + "] to a DateTime.");
            }
            return null;
        }
        try {
            return new DateTime(DateUtils.parseDateStrictly(targetString, COMMON_PATTERNS));
        }
        catch (ParseException e) {
            try {
                return new DateTime(targetString);
            }
            catch (Throwable e2) {
                if (fail.booleanValue()) {
                    throw new BoxCastException("Can't cast [" + targetString + "] to a DateTime.");
                }
                return null;
            }
        }
    }

    public static boolean isKnownDateClass(Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{DateTime.class, ZonedDateTime.class, Calendar.class, LocalDateTime.class, LocalDate.class, Date.class, java.util.Date.class}, (Object)object3, n)) {
            case 0 -> {
                DateTime d = (DateTime)object3;
                yield true;
            }
            case 1 -> {
                ZonedDateTime d = (ZonedDateTime)object3;
                yield true;
            }
            case 2 -> {
                Calendar d = (Calendar)object3;
                yield true;
            }
            case 3 -> {
                LocalDateTime d = (LocalDateTime)object3;
                yield true;
            }
            case 4 -> {
                LocalDate d = (LocalDate)object3;
                yield true;
            }
            case 5 -> {
                Date d = (Date)object3;
                yield true;
            }
            case 6 -> {
                java.util.Date d = (java.util.Date)object3;
                yield true;
            }
            default -> false;
        };
    }
}

