/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.math.BigDecimal;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class DoubleCaster
implements IBoxCaster {
    public static CastAttempt<Double> attempt(Object object) {
        return CastAttempt.ofNullable(DoubleCaster.cast(object, false));
    }

    public static Double cast(Object object) {
        return DoubleCaster.cast(object, true);
    }

    public static Double cast(Object object, Boolean fail) {
        String stringValue;
        Double result;
        if (object == null) {
            return 0.0;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            if (BoxRuntime.getInstance().inDebugMode().booleanValue()) {
                System.out.println("Potential precision loss casting BigDecimal to double");
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                for (int i2 = 1; i2 < 11 && i2 != stackTrace.length - 1 && !stackTrace[i2].getClassName().startsWith("boxgenerated."); ++i2) {
                    System.out.println("  " + String.valueOf(stackTrace[i2]));
                }
                Array tagContext = ExceptionUtil.getTagContext();
                tagContext.forEach(i -> {
                    Struct item = (Struct)i;
                    System.out.println("  " + item.getAsString(Key.template) + ":" + item.getAsInteger(Key.line) + " " + item.getAsString(Key.id));
                });
            }
            return bd.doubleValue();
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return num.doubleValue();
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? 1.0 : 0.0;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes")) {
                return 1.0;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no")) {
                return 0.0;
            }
        }
        if ((result = DoubleCaster.parseDouble(stringValue = StringCaster.cast(object, false))) != null) {
            return result;
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a double.", object.toString()));
        }
        return null;
    }

    private static Double parseDouble(String value) {
        if (value == null) {
            return null;
        }
        if (NumberUtils.isCreatable(value)) {
            try {
                return Double.parseDouble(value);
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

