/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class FloatCaster
implements IBoxCaster {
    public static CastAttempt<Float> attempt(Object object) {
        return CastAttempt.ofNullable(FloatCaster.cast(object, false));
    }

    public static Float cast(Object object) {
        return FloatCaster.cast(object, true);
    }

    public static Float cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a float.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Number) {
            Number num = (Number)object;
            return Float.valueOf(num.floatValue());
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return Float.valueOf(bool != false ? 1.0f : 0.0f);
        }
        CastAttempt<Number> number = NumberCaster.attempt(object);
        if (number.wasSuccessful()) {
            return Float.valueOf(number.get().floatValue());
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a float.");
        }
        return null;
    }
}

