/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.runtime.SwitchBootstraps;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleConsumer;
import java.util.function.DoubleFunction;
import java.util.function.DoubleToIntFunction;
import java.util.function.DoubleToLongFunction;
import java.util.function.DoubleUnaryOperator;
import java.util.function.Function;
import java.util.function.IntBinaryOperator;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongFunction;
import java.util.function.LongToDoubleFunction;
import java.util.function.LongToIntFunction;
import java.util.function.LongUnaryOperator;
import java.util.function.ObjDoubleConsumer;
import java.util.function.ObjIntConsumer;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.JavaMethod;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class FunctionCaster
implements IBoxCaster {
    static final List<String> objectMethodNames = Arrays.stream(Object.class.getMethods()).map(Method::getName).collect(Collectors.toList());

    public static CastAttempt<ortus.boxlang.runtime.types.Function> attempt(Object object) {
        return FunctionCaster.attempt(object, null);
    }

    public static CastAttempt<ortus.boxlang.runtime.types.Function> attempt(Object object, String SAMClass) {
        return CastAttempt.ofNullable(FunctionCaster.cast(object, SAMClass, false));
    }

    public static ortus.boxlang.runtime.types.Function cast(Object object, String SAMClass) {
        return FunctionCaster.cast(object, SAMClass, true);
    }

    public static ortus.boxlang.runtime.types.Function cast(Object object) {
        return FunctionCaster.cast(object, true);
    }

    public static ortus.boxlang.runtime.types.Function cast(Object object, boolean fail) {
        return FunctionCaster.cast(object, null, fail);
    }

    public static ortus.boxlang.runtime.types.Function cast(Object object, String SAMClass, boolean fail) {
        String SAMName;
        if (object == null) {
            if (fail) {
                throw new BoxCastException("Null cannot be cast to a Function");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof ortus.boxlang.runtime.types.Function) {
            ortus.boxlang.runtime.types.Function fun = (ortus.boxlang.runtime.types.Function)object;
            return fun;
        }
        if (SAMClass != null && !SAMClass.isBlank() && (SAMName = FunctionCaster.getSAMName(object, SAMClass.trim())) != null) {
            return new JavaMethod(Key.of(SAMName), DynamicObject.of(object));
        }
        if (fail) {
            throw new BoxCastException(String.format("Value [%s] cannot be cast to a Function", object.getClass().getName()));
        }
        return null;
    }

    public static String getSAMName(Object object, String SAMClass) {
        String SAMName;
        Class<?> clazz;
        SAMClass = FunctionCaster.expandKnownClasses(SAMClass);
        try {
            clazz = BoxRuntime.getInstance().getClass().getClassLoader().loadClass(SAMClass);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            return null;
        }
        if (clazz.isInterface() && !clazz.isAssignableFrom(object.getClass())) {
            return null;
        }
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{BiConsumer.class, Consumer.class, DoubleConsumer.class, IntConsumer.class, LongConsumer.class, ObjDoubleConsumer.class, ObjIntConsumer.class, ObjLongConsumer.class, DoubleBinaryOperator.class, DoubleFunction.class, DoubleToIntFunction.class, DoubleToLongFunction.class, UnaryOperator.class, BinaryOperator.class, DoubleUnaryOperator.class, Function.class, IntBinaryOperator.class, IntFunction.class, IntToDoubleFunction.class, IntToLongFunction.class, IntUnaryOperator.class, LongBinaryOperator.class, LongFunction.class, LongToDoubleFunction.class, LongToIntFunction.class, LongUnaryOperator.class, BiFunction.class, Predicate.class, BiPredicate.class, Supplier.class, Comparator.class}, (Object)object3, n)) {
            case 0: {
                BiConsumer a = (BiConsumer)object3;
                String string = "accept";
                break;
            }
            case 1: {
                Consumer b = (Consumer)object3;
                String string = "accept";
                break;
            }
            case 2: {
                DoubleConsumer c = (DoubleConsumer)object3;
                String string = "accept";
                break;
            }
            case 3: {
                IntConsumer d = (IntConsumer)object3;
                String string = "accept";
                break;
            }
            case 4: {
                LongConsumer e = (LongConsumer)object3;
                String string = "accept";
                break;
            }
            case 5: {
                ObjDoubleConsumer f = (ObjDoubleConsumer)object3;
                String string = "accept";
                break;
            }
            case 6: {
                ObjIntConsumer g = (ObjIntConsumer)object3;
                String string = "accept";
                break;
            }
            case 7: {
                ObjLongConsumer h = (ObjLongConsumer)object3;
                String string = "accept";
                break;
            }
            case 8: {
                DoubleBinaryOperator i = (DoubleBinaryOperator)object3;
                String string = "applyAsDouble";
                break;
            }
            case 9: {
                DoubleFunction j = (DoubleFunction)object3;
                String string = "apply";
                break;
            }
            case 10: {
                DoubleToIntFunction k = (DoubleToIntFunction)object3;
                String string = "applyAsInt";
                break;
            }
            case 11: {
                DoubleToLongFunction l = (DoubleToLongFunction)object3;
                String string = "applyAsLong";
                break;
            }
            case 12: {
                UnaryOperator z = (UnaryOperator)object3;
                String string = "apply";
                break;
            }
            case 13: {
                BinaryOperator aa = (BinaryOperator)object3;
                String string = "apply";
                break;
            }
            case 14: {
                DoubleUnaryOperator m = (DoubleUnaryOperator)object3;
                String string = "applyAsDouble";
                break;
            }
            case 15: {
                Function n2 = (Function)object3;
                String string = "apply";
                break;
            }
            case 16: {
                IntBinaryOperator o = (IntBinaryOperator)object3;
                String string = "applyAsInt";
                break;
            }
            case 17: {
                IntFunction p = (IntFunction)object3;
                String string = "apply";
                break;
            }
            case 18: {
                IntToDoubleFunction q = (IntToDoubleFunction)object3;
                String string = "applyAsDouble";
                break;
            }
            case 19: {
                IntToLongFunction r = (IntToLongFunction)object3;
                String string = "applyAsLong";
                break;
            }
            case 20: {
                IntUnaryOperator s = (IntUnaryOperator)object3;
                String string = "applyAsInt";
                break;
            }
            case 21: {
                LongBinaryOperator t = (LongBinaryOperator)object3;
                String string = "applyAsLong";
                break;
            }
            case 22: {
                LongFunction u = (LongFunction)object3;
                String string = "apply";
                break;
            }
            case 23: {
                LongToDoubleFunction v = (LongToDoubleFunction)object3;
                String string = "applyAsDouble";
                break;
            }
            case 24: {
                LongToIntFunction w = (LongToIntFunction)object3;
                String string = "applyAsInt";
                break;
            }
            case 25: {
                LongUnaryOperator x = (LongUnaryOperator)object3;
                String string = "applyAsLong";
                break;
            }
            case 26: {
                BiFunction y = (BiFunction)object3;
                String string = "apply";
                break;
            }
            case 27: {
                Predicate bb = (Predicate)object3;
                String string = "test";
                break;
            }
            case 28: {
                BiPredicate cc = (BiPredicate)object3;
                String string = "test";
                break;
            }
            case 29: {
                Supplier dd = (Supplier)object3;
                String string = "get";
                break;
            }
            case 30: {
                Comparator ee = (Comparator)object3;
                String string = "compare";
                break;
            }
            default: {
                String string = SAMName = null;
            }
        }
        if (SAMName != null) {
            return SAMName;
        }
        List filteredMethods = Arrays.stream(clazz.getMethods()).filter(method -> Modifier.isAbstract(method.getModifiers()) && !Modifier.isStatic(method.getModifiers())).filter(method -> !objectMethodNames.contains(method.getName()) || !Arrays.equals(method.getParameterTypes(), Arrays.stream(Object.class.getMethods()).filter(m -> m.getName().equals(method.getName())).findFirst().map(Method::getParameterTypes).orElse(new Class[0]))).collect(Collectors.toList());
        long count = filteredMethods.size();
        if (count == 1L) {
            return ((Method)filteredMethods.get(0)).getName();
        }
        return null;
    }

    private static String expandKnownClasses(String SAMClass) {
        return switch (SAMClass.toLowerCase()) {
            case "consumer", "java.util.function.consumer" -> "java.util.function.Consumer";
            case "biconsumer", "java.util.function.biconsumer" -> "java.util.function.BiConsumer";
            case "doubleconsumer", "java.util.function.doubleconsumer" -> "java.util.function.DoubleConsumer";
            case "intconsumer", "java.util.function.intconsumer" -> "java.util.function.IntConsumer";
            case "longconsumer", "java.util.function.longconsumer" -> "java.util.function.LongConsumer";
            case "objdoubleconsumer", "java.util.function.objdoubleconsumer" -> "java.util.function.ObjDoubleConsumer";
            case "objintconsumer", "java.util.function.objintconsumer" -> "java.util.function.ObjIntConsumer";
            case "objlongconsumer", "java.util.function.objlongconsumer" -> "java.util.function.ObjLongConsumer";
            case "doublebinaryoperator", "java.util.function.doublebinaryoperator" -> "java.util.function.DoubleBinaryOperator";
            case "doublefunction", "java.util.function.doublefunction" -> "java.util.function.DoubleFunction";
            case "doubletointfunction", "java.util.function.doubletointfunction" -> "java.util.function.DoubleToIntFunction";
            case "doubletolongfunction", "java.util.function.doubletolongfunction" -> "java.util.function.DoubleToLongFunction";
            case "unaryoperator", "java.util.function.unaryoperator" -> "java.util.function.UnaryOperator";
            case "binaryoperator", "java.util.function.binaryoperator" -> "java.util.function.BinaryOperator";
            case "doubleunaryoperator", "java.util.function.doubleunaryoperator" -> "java.util.function.DoubleUnaryOperator";
            case "function", "java.util.function.function" -> "java.util.function.Function";
            case "intbinaryoperator", "java.util.function.intbinaryoperator" -> "java.util.function.IntBinaryOperator";
            case "intfunction", "java.util.function.intfunction" -> "java.util.function.IntFunction";
            case "inttodoublefunction", "java.util.function.inttodoublefunction" -> "java.util.function.IntToDoubleFunction";
            case "inttolongfunction", "java.util.function.inttolongfunction" -> "java.util.function.IntToLongFunction";
            case "intunaryoperator", "java.util.function.intunaryoperator" -> "java.util.function.IntUnaryOperator";
            case "longbinaryoperator", "java.util.function.longbinaryoperator" -> "java.util.function.LongBinaryOperator";
            case "longfunction", "java.util.function.longfunction" -> "java.util.function.LongFunction";
            case "longtodoublefunction", "java.util.function.longtodoublefunction" -> "java.util.function.LongToDoubleFunction";
            case "longtointfunction", "java.util.function.longtointfunction" -> "java.util.function.LongToIntFunction";
            case "longunaryoperator", "java.util.function.longunaryoperator" -> "java.util.function.LongUnaryOperator";
            case "bifunction", "java.util.function.bifunction" -> "java.util.function.BiFunction";
            case "predicate", "java.util.function.predicate" -> "java.util.function.Predicate";
            case "bipredicate", "java.util.function.bipredicate" -> "java.util.function.BiPredicate";
            case "supplier", "java.util.function.supplier" -> "java.util.function.Supplier";
            case "comparator", "java.util.comparator" -> "java.util.Comparator";
            default -> SAMClass;
        };
    }
}

