/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.List;
import java.util.Optional;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.BigDecimalCaster;
import ortus.boxlang.runtime.dynamic.casters.BigIntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.ByteCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.CharacterCaster;
import ortus.boxlang.runtime.dynamic.casters.DateTimeCaster;
import ortus.boxlang.runtime.dynamic.casters.DoubleCaster;
import ortus.boxlang.runtime.dynamic.casters.FloatCaster;
import ortus.boxlang.runtime.dynamic.casters.FunctionCaster;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.IntegerCaster;
import ortus.boxlang.runtime.dynamic.casters.KeyCaster;
import ortus.boxlang.runtime.dynamic.casters.LongCaster;
import ortus.boxlang.runtime.dynamic.casters.ModifiableArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.ModifiableStructCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.dynamic.casters.ShortCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCasterLoose;
import ortus.boxlang.runtime.dynamic.casters.ThrowableCaster;
import ortus.boxlang.runtime.dynamic.casters.TimeCaster;
import ortus.boxlang.runtime.dynamic.casters.XMLCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.operators.InstanceOf;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.types.BoxLangType;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.NullValue;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class GenericCaster
implements IBoxCaster {
    public static CastAttempt<Object> attempt(IBoxContext context, Object object, Object oType, boolean strict) {
        String type;
        if (oType instanceof BoxLangType) {
            BoxLangType boxType = (BoxLangType)((Object)oType);
            type = boxType.name();
        } else {
            type = StringCaster.cast(oType);
        }
        if (type.equalsIgnoreCase("null") || type.equalsIgnoreCase("void")) {
            if (strict && object != null) {
                throw new BoxCastException(String.format("Cannot cast type [%s] to %s.", object.getClass().getName(), type));
            }
            return CastAttempt.ofNullable(new NullValue());
        }
        if (type.equalsIgnoreCase("any") && object == null) {
            return CastAttempt.ofNullable(new NullValue());
        }
        return CastAttempt.ofNullable(GenericCaster.cast(context, object, type, false));
    }

    public static CastAttempt<Object> attempt(IBoxContext context, Object object, Object oType) {
        return GenericCaster.attempt(context, object, oType, false);
    }

    public static Object cast(IBoxContext context, Object object, Object oType) {
        return GenericCaster.cast(context, object, oType, true);
    }

    public static Object cast(IBoxContext context, Object object, Object oType, Boolean fail) {
        String originalCaseType = StringCaster.cast(oType);
        String type = originalCaseType.toLowerCase();
        if (type.equals("null") || type.equals("void")) {
            return null;
        }
        if (type.equals("any") || type.equals("object")) {
            return object;
        }
        if (type.endsWith("[]")) {
            Object result;
            String newType = type.substring(0, type.length() - 2);
            originalCaseType = originalCaseType.substring(0, originalCaseType.length() - 2);
            Class<Object> newTypeClass = GenericCaster.getClassFromType(context, newType, originalCaseType, false);
            Boolean convertToArray = false;
            if (newTypeClass == null) {
                convertToArray = true;
                newTypeClass = Object.class;
            }
            if (object.getClass().isArray()) {
                if (object.getClass().getComponentType().equals(newTypeClass)) {
                    return object;
                }
                result = GenericCaster.castNativeArrayToNativeArray(context, object, newType, fail, newTypeClass);
            } else if (object instanceof List) {
                List incomingList = (List)object;
                Object[] incomingArray = incomingList.toArray();
                result = GenericCaster.castNativeArrayToNativeArray(context, incomingArray, newType, fail, newTypeClass);
            } else {
                throw new BoxCastException(String.format("You asked for type %s, but input %s cannot be cast to an array.", type, object.getClass().getName()));
            }
            if (convertToArray.booleanValue()) {
                return ortus.boxlang.runtime.types.Array.fromArray((Object[])result);
            }
            return result;
        }
        if (type.equals("string")) {
            return StringCaster.cast(object, fail);
        }
        if (type.equals("double")) {
            return DoubleCaster.cast(object, fail);
        }
        if (type.equals("numeric") || type.equals("number")) {
            return NumberCaster.cast(object, fail);
        }
        if (type.equals("boolean")) {
            return BooleanCaster.cast(object, fail);
        }
        if (type.equals("bit")) {
            return Boolean.TRUE.equals(BooleanCaster.cast(object, fail)) ? 1 : 0;
        }
        if (type.equals("bigdecimal") || type.equals("decimal")) {
            return BigDecimalCaster.cast(object, fail);
        }
        if (type.equals("biginteger")) {
            return BigIntegerCaster.cast(object, fail);
        }
        if (type.equals("char")) {
            return CharacterCaster.cast(object, fail);
        }
        if (type.equals("byte")) {
            return ByteCaster.cast(object, fail);
        }
        if (type.equals("int") || type.equals("integer")) {
            return IntegerCaster.cast(object, fail);
        }
        if (type.equals("long")) {
            return LongCaster.cast(object, fail);
        }
        if (type.equals("short")) {
            return ShortCaster.cast(object, fail);
        }
        if (type.equals("float")) {
            return FloatCaster.cast(object, fail);
        }
        if (type.equals("array")) {
            return ArrayCaster.cast(object, fail);
        }
        if (object instanceof DateTime || type.equals("datetime") || type.equals("date") || type.equals("timestamp")) {
            return DateTimeCaster.cast(object, fail);
        }
        if (type.equals("time")) {
            return TimeCaster.cast(object, fail);
        }
        if (type.equals("modifiablearray")) {
            return ModifiableArrayCaster.cast(object, fail);
        }
        if (type.equals("struct")) {
            return StructCaster.cast(object, fail);
        }
        if (type.equals("structloose")) {
            return StructCasterLoose.cast(object, fail);
        }
        if (type.equals("modifiablestruct")) {
            return ModifiableStructCaster.cast(object, fail);
        }
        if (type.equals("xml")) {
            return XMLCaster.cast(object, fail);
        }
        if (type.equals("function")) {
            return FunctionCaster.cast(object, fail);
        }
        if (type.equals("throwable")) {
            return ThrowableCaster.cast(object, fail);
        }
        if (type.equals("key")) {
            return KeyCaster.cast(object, fail);
        }
        if (type.startsWith("function:") && type.length() > 9) {
            return FunctionCaster.cast(object, originalCaseType.substring(9), fail);
        }
        if (type.equals("query")) {
            if (object instanceof Query) {
                return object;
            }
            if (fail.booleanValue()) {
                throw new BoxCastException(String.format("Cannot cast %s, to a Query.", object.getClass().getName()));
            }
            return null;
        }
        if (type.equals("stream")) {
            if (object instanceof Stream) {
                return object;
            }
            if (object instanceof IntStream) {
                IntStream is = (IntStream)object;
                return is.boxed();
            }
            if (object instanceof DoubleStream) {
                DoubleStream ds = (DoubleStream)object;
                return ds.boxed();
            }
            if (object instanceof LongStream) {
                LongStream ls = (LongStream)object;
                return ls.boxed();
            }
            if (fail.booleanValue()) {
                throw new BoxCastException(String.format("Cannot cast %s, to a Stream.", object.getClass().getName()));
            }
            return null;
        }
        if (type.equals("component") || type.equals("class")) {
            if (object instanceof IClassRunnable) {
                return object;
            }
            if (fail.booleanValue()) {
                throw new BoxCastException(String.format("Cannot cast %s, to a %s.", object.getClass().getName(), type));
            }
            return null;
        }
        if (InstanceOf.invoke(context, object, type).booleanValue()) {
            return object;
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Could not cast object [%s] to type [%s]", object.getClass().getSimpleName(), type));
        }
        return null;
    }

    private static Object castNativeArrayToNativeArray(IBoxContext context, Object object, String newType, boolean fail, Class<?> newTypeClass) {
        int len = Array.getLength(object);
        Object result = Array.newInstance(newTypeClass, len);
        for (int i = len - 1; i >= 0; --i) {
            Object v = GenericCaster.cast(context, Array.get(object, i), newType, fail);
            Array.set(result, i, v);
        }
        return result;
    }

    public static Class<?> getClassFromType(IBoxContext context, String type) {
        return GenericCaster.getClassFromType(context, type, type, true);
    }

    public static Class<?> getClassFromType(IBoxContext context, String type, String originalCaseType) {
        return GenericCaster.getClassFromType(context, type, originalCaseType, true);
    }

    public static Class<?> getClassFromType(IBoxContext context, String type, String originalCaseType, Boolean fail) {
        if (originalCaseType.equals("byte")) {
            return Byte.TYPE;
        }
        if (originalCaseType.equals("char")) {
            return Character.TYPE;
        }
        if (originalCaseType.equals("short")) {
            return Short.TYPE;
        }
        if (originalCaseType.equals("int")) {
            return Integer.TYPE;
        }
        if (originalCaseType.equals("long")) {
            return Long.TYPE;
        }
        if (originalCaseType.equals("float")) {
            return Float.TYPE;
        }
        if (originalCaseType.equals("double")) {
            return Double.TYPE;
        }
        if (originalCaseType.equals("boolean")) {
            return Boolean.TYPE;
        }
        if (type.equals("bigdecimal") || type.equals("java.math.bigdecimal")) {
            return BigDecimal.class;
        }
        if (type.equals("biginteger") || type.equals("java.math.biginteger")) {
            return BigInteger.class;
        }
        if (type.equals("boolean") || type.equals("java.lang.boolean")) {
            return Boolean.class;
        }
        if (type.equals("byte") || type.equals("java.lang.byte")) {
            return Byte.class;
        }
        if (type.equals("char") || type.equals("java.lang.char")) {
            return Character.class;
        }
        if (type.equals("double") || type.equals("java.lang.double")) {
            return Double.class;
        }
        if (type.equals("float") || type.equals("java.lang.float")) {
            return Float.class;
        }
        if (type.equals("instant") || type.equals("java.time.instant")) {
            return Instant.class;
        }
        if (type.equals("int") || type.equals("integer") || type.equals("java.lang.integer")) {
            return Integer.class;
        }
        if (type.equals("LocalDate") || type.equals("java.time.LocalDate")) {
            return LocalDate.class;
        }
        if (type.equals("LocalDateTime") || type.equals("java.time.LocalDateTime")) {
            return LocalDateTime.class;
        }
        if (type.equals("LocalTime") || type.equals("java.time.LocalTime")) {
            return LocalTime.class;
        }
        if (type.equals("long") || type.equals("java.lang.long")) {
            return Long.class;
        }
        if (type.equals("short") || type.equals("java.lang.short")) {
            return Short.class;
        }
        if (type.equals("string") || type.equals("java.lang.string")) {
            return String.class;
        }
        if (type.equals("object") || type.equals("java.lang.object")) {
            return Object.class;
        }
        Optional<DynamicObject> loadResult = BoxRuntime.getInstance().getClassLocator().safeLoad(context, originalCaseType, "java");
        if (loadResult.isPresent()) {
            return loadResult.get().getTargetClass();
        }
        if (!fail.booleanValue()) {
            return null;
        }
        throw new BoxCastException(String.format("Invalid cast type [%s]", originalCaseType));
    }
}

