/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class IntegerCaster
implements IBoxCaster {
    public static CastAttempt<Integer> attempt(Object object) {
        return CastAttempt.ofNullable(IntegerCaster.cast(object, false));
    }

    public static Integer cast(Object object) {
        return IntegerCaster.cast(object, true);
    }

    public static Integer cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a int.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Number) {
            Number num = (Number)object;
            return num.intValue();
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? 1 : 0;
        }
        String theValue = StringCaster.cast(object, fail);
        if (theValue == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException(String.format("Can't cast %s to a int.", theValue));
            }
            return null;
        }
        if (IntegerCaster.isInteger(theValue)) {
            return Integer.valueOf(theValue);
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast %s to a int.", theValue));
        }
        return null;
    }

    public static boolean isInteger(String value) {
        if (value == null) {
            return false;
        }
        String toParse = value;
        if (value.startsWith("-") || value.startsWith("+")) {
            toParse = toParse.substring(1);
        }
        return !toParse.isEmpty() && toParse.chars().allMatch(Character::isDigit);
    }
}

