/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class KeyCaster
implements IBoxCaster {
    public static CastAttempt<Key> attempt(Object object) {
        return CastAttempt.ofNullable(KeyCaster.cast(object, false));
    }

    public static Key cast(Object object) {
        return KeyCaster.cast(object, true);
    }

    public static Key cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Key.");
            }
            return null;
        }
        if (object instanceof Key) {
            Key key = (Key)object;
            return key;
        }
        if (object instanceof String) {
            String str = (String)object;
            return Key.of(str);
        }
        CastAttempt<String> castAttempt = StringCaster.attempt(object);
        if (castAttempt.wasSuccessful()) {
            return Key.of(castAttempt.get());
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a Key.");
        }
        return null;
    }
}

