/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class LongCaster
implements IBoxCaster {
    public static CastAttempt<Long> attempt(Object object) {
        return CastAttempt.ofNullable(LongCaster.cast(object, false));
    }

    public static Long cast(Object object) {
        return LongCaster.cast(object, true);
    }

    public static Long cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a long.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Number) {
            Number num = (Number)object;
            return num.longValue();
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? 1L : 0L;
        }
        CastAttempt<Number> number = NumberCaster.attempt(object);
        if (number.wasSuccessful()) {
            return number.get().longValue();
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a long.");
        }
        return null;
    }
}

