/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.util.List;
import ortus.boxlang.runtime.dynamic.casters.ArrayCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableArray;

public class ModifiableArrayCaster
implements IBoxCaster {
    public static CastAttempt<Array> attempt(Object object) {
        return CastAttempt.ofNullable(ModifiableArrayCaster.cast(object, false));
    }

    public static Array cast(Object object) {
        return ModifiableArrayCaster.cast(object, true);
    }

    public static Array cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Array.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof UnmodifiableArray) {
            throw new BoxCastException("Can't cast UnmodifiableArray to a modifiable Array.");
        }
        if (object.getClass().isArray()) {
            throw new BoxCastException("Can't cast a Java Array to a modifiable Array.");
        }
        if (object instanceof List && object.getClass().getName().contains("Immutable")) {
            throw new BoxCastException("Can't cast Unmodifiable List to a modifiable Array.");
        }
        return ArrayCaster.cast(object, fail);
    }
}

