/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.util.Map;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.unmodifiable.UnmodifiableStruct;

public class ModifiableStructCaster
implements IBoxCaster {
    public static CastAttempt<IStruct> attempt(Object object) {
        return CastAttempt.ofNullable(ModifiableStructCaster.cast(object, false));
    }

    public static IStruct cast(Object object) {
        return ModifiableStructCaster.cast(object, true);
    }

    public static IStruct cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Struct.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof UnmodifiableStruct) {
            throw new BoxCastException("Can't cast UnmodifiableStruct to a modifiable Struct.");
        }
        if (object instanceof Map && object.getClass().getName().startsWith("java.util.ImmutableCollections$")) {
            throw new BoxCastException("Can't cast Unmodifiable Map to a modifiable Struct.");
        }
        if (object instanceof Map && object.getClass().getName().contains("Unmodifiable")) {
            throw new BoxCastException("Can't cast Unmodifiable Map to a modifiable Struct.");
        }
        return StructCaster.cast(object, fail);
    }
}

