/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.math.BigDecimal;
import java.math.BigInteger;
import org.apache.commons.lang3.math.NumberUtils;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.util.MathUtil;

public class NumberCaster
implements IBoxCaster {
    public static CastAttempt<Number> attempt(Object object) {
        return CastAttempt.ofNullable(NumberCaster.cast(object, false));
    }

    public static Number cast(Object object) {
        return NumberCaster.cast(object, true);
    }

    public static Number cast(Object object, Boolean fail) {
        String stringValue;
        Number result;
        if (object == null) {
            return 0;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Integer) {
            Integer i = (Integer)object;
            return i;
        }
        if (object instanceof Long) {
            Long l = (Long)object;
            return l;
        }
        if (object instanceof Double) {
            Double d = (Double)object;
            return d;
        }
        if (object instanceof BigDecimal) {
            BigDecimal bd = (BigDecimal)object;
            return bd;
        }
        if (object instanceof BigInteger) {
            BigInteger bi = (BigInteger)object;
            return new BigDecimal(bi, MathUtil.getMathContext());
        }
        if (object instanceof Number) {
            Number num = (Number)object;
            return new BigDecimal(num.doubleValue(), MathUtil.getMathContext());
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? 1 : 0;
        }
        if (object instanceof String) {
            String str = (String)object;
            if (str.equalsIgnoreCase("true") || str.equalsIgnoreCase("yes")) {
                return 1;
            }
            if (str.equalsIgnoreCase("false") || str.equalsIgnoreCase("no")) {
                return 0;
            }
        }
        if ((result = NumberCaster.parseNumber(stringValue = StringCaster.cast(object, false))) != null) {
            return result;
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a Number.", object.toString()));
        }
        return null;
    }

    private static Number parseNumber(String value) {
        if (value == null) {
            return null;
        }
        if (value.endsWith(".")) {
            value = value.substring(0, value.length() - 1);
        }
        if (NumberUtils.isCreatable(value)) {
            try {
                int len = value.length();
                if (value.contains(".") || value.contains("e") || value.contains("E")) {
                    if (MathUtil.isHighPrecisionMath() || len > 19) {
                        return new BigDecimal(value, MathUtil.getMathContext());
                    }
                    return Double.parseDouble(value);
                }
                if (len <= 10) {
                    return Integer.parseInt(value);
                }
                if (len <= 19) {
                    return Long.parseLong(value);
                }
                return new BigDecimal(value, MathUtil.getMathContext());
            }
            catch (Exception e) {
                return null;
            }
        }
        return null;
    }
}

