/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.NumberCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class ShortCaster
implements IBoxCaster {
    public static CastAttempt<Short> attempt(Object object) {
        return CastAttempt.ofNullable(ShortCaster.cast(object, false));
    }

    public static Short cast(Object object) {
        return ShortCaster.cast(object, true);
    }

    public static Short cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a short.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Number) {
            Number num = (Number)object;
            return num.shortValue();
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return (short)(bool != false ? 1 : 0);
        }
        CastAttempt<Number> number = NumberCaster.attempt(object);
        if (number.wasSuccessful()) {
            return number.get().shortValue();
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a short.");
        }
        return null;
    }
}

