/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Arrays;
import java.util.Date;
import java.util.Locale;
import java.util.UUID;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class StringCaster
implements IBoxCaster {
    public static CastAttempt<String> attempt(Object object) {
        return StringCaster.attempt(object, null);
    }

    public static CastAttempt<String> attempt(Object object, String encoding) {
        return CastAttempt.ofNullable(StringCaster.cast(object, encoding, false));
    }

    public static String cast(Object object, String encoding) {
        return StringCaster.cast(object, encoding, true);
    }

    public static String cast(Object object) {
        return StringCaster.cast(object, true);
    }

    public static String cast(Object object, Boolean fail) {
        return StringCaster.cast(object, null, fail);
    }

    public static String cast(Object object, String encoding, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a string.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Key) {
            Key key = (Key)object;
            return key.getName();
        }
        if (object instanceof String) {
            String str = (String)object;
            return str;
        }
        if (object instanceof Boolean) {
            Boolean bool = (Boolean)object;
            return bool != false ? "true" : "false";
        }
        if (object instanceof Character) {
            Character chr = (Character)object;
            return chr.toString();
        }
        if (object instanceof Character[]) {
            Object[] ca = (Character[])object;
            return Arrays.toString(ca);
        }
        if (object instanceof Path) {
            Path path = (Path)object;
            return path.toString();
        }
        if (object instanceof Date) {
            Date date = (Date)object;
            return new DateTime(date).toString();
        }
        if (object instanceof Instant) {
            Instant instant = (Instant)object;
            return new DateTime(instant).toString();
        }
        if (object instanceof DateTime) {
            DateTime dt = (DateTime)object;
            return dt.toString();
        }
        if (object instanceof Locale) {
            Locale lc = (Locale)object;
            return lc.toString();
        }
        if (object instanceof UUID) {
            UUID uuid = (UUID)object;
            return uuid.toString();
        }
        if (object instanceof ZoneId) {
            ZoneId castedZone = (ZoneId)object;
            return castedZone.getId();
        }
        if (object instanceof StringBuilder) {
            StringBuilder sb = (StringBuilder)object;
            return sb.toString();
        }
        if (object instanceof StringBuffer) {
            StringBuffer sb = (StringBuffer)object;
            return sb.toString();
        }
        if (object instanceof Integer || object instanceof Long || object instanceof Short || object instanceof Byte || object instanceof BigInteger) {
            return object.toString();
        }
        if (object instanceof BigDecimal || object instanceof Float || object instanceof Double) {
            String result = object.toString();
            if (result.endsWith(".0")) {
                return result.substring(0, result.length() - 2);
            }
            return result;
        }
        if (object instanceof Number) {
            return object.toString();
        }
        if (object instanceof byte[]) {
            byte[] b = (byte[])object;
            if (encoding != null && !encoding.isEmpty()) {
                return new String(b, Charset.forName(encoding));
            }
            return new String(b);
        }
        if (object instanceof XML) {
            XML xml = (XML)object;
            return xml.asString();
        }
        if (object instanceof URI) {
            URI uri = (URI)object;
            return uri.toString();
        }
        if (object instanceof URL) {
            URL url = (URL)object;
            return url.toString();
        }
        if (object instanceof InetSocketAddress) {
            InetSocketAddress inet = (InetSocketAddress)object;
            return inet.toString();
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a string.");
        }
        return null;
    }
}

