/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.util.Map;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.ArgumentsScope;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.StructMapWrapper;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;

public class StructCaster
implements IBoxCaster {
    public static CastAttempt<IStruct> attempt(Object object) {
        return CastAttempt.ofNullable(StructCaster.cast(object, false));
    }

    public static IStruct cast(Object object) {
        return StructCaster.cast(object, true);
    }

    public static IStruct cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Struct.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof Throwable) {
            Throwable t = (Throwable)object;
            return ExceptionUtil.throwableToStruct(t);
        }
        if (object instanceof ArgumentsScope) {
            ArgumentsScope args = (ArgumentsScope)object;
            return args;
        }
        if (object instanceof IStruct) {
            IStruct col = (IStruct)object;
            return col;
        }
        if (object instanceof Map) {
            Map map = (Map)object;
            return StructMapWrapper.of(map);
        }
        if (fail.booleanValue()) {
            throw new BoxCastException(String.format("Can't cast [%s] to a Struct.", object.getClass().getName()));
        }
        return null;
    }
}

