/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.CustomException;

public class ThrowableCaster
implements IBoxCaster {
    public static CastAttempt<Throwable> attempt(Object object) {
        return CastAttempt.ofNullable(ThrowableCaster.cast(object, false));
    }

    public static Throwable cast(Object object) {
        return ThrowableCaster.cast(object, true);
    }

    public static Throwable cast(Object object, Boolean fail) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a Throwable.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) != null) {
            if (object instanceof Throwable) {
                Throwable t = (Throwable)object;
                return t;
            }
            CastAttempt<IStruct> structObjectCast = StructCaster.attempt(object);
            String message = null;
            String detail = null;
            String errorcode = null;
            String type = null;
            Object extendedinfo = null;
            Throwable oCause = null;
            if (structObjectCast.wasSuccessful()) {
                IStruct oStruct = structObjectCast.get();
                if (!oStruct.containsKey(Key.message) || oStruct.get(Key.message) == null) {
                    throw new BoxRuntimeException("Cannot throw struct object as it does not contain at least a message key");
                }
                message = StringCaster.cast(oStruct.get(Key.message));
                if (oStruct.containsKey(Key.detail)) {
                    detail = StringCaster.cast(oStruct.get(Key.detail), false);
                }
                if (oStruct.containsKey(Key.errorcode)) {
                    errorcode = StringCaster.cast(oStruct.get(Key.errorcode), false);
                }
                if (oStruct.containsKey(Key.type)) {
                    type = StringCaster.cast(oStruct.get(Key.type), false);
                }
                if (oStruct.containsKey(Key.extendedinfo)) {
                    extendedinfo = oStruct.get(Key.extendedinfo);
                }
                if (oStruct.containsKey(Key.stackTrace) && oStruct.get(Key.stackTrace) != null && (extendedinfo == null || extendedinfo instanceof String)) {
                    extendedinfo = extendedinfo == null ? "" : extendedinfo;
                    extendedinfo = (String)extendedinfo + (!((String)extendedinfo).isBlank() ? "\n" : "") + StringCaster.cast(oStruct.get(Key.stackTrace));
                }
                if (oStruct.containsKey(Key.cause)) {
                    oCause = ThrowableCaster.cast(oStruct.get(Key.cause), false);
                }
                return new CustomException(message, detail, errorcode, type == null ? "Custom" : type, extendedinfo, oCause);
            }
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to a Throwable.");
        }
        return null;
    }
}

