/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Calendar;
import java.util.Date;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.DateTime;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;

public class TimeCaster
implements IBoxCaster {
    private static final String[] COMMON_FORMATS = new String[]{"h:mm:ss a z", "h:mm:ss a", "h:mm a", "h a", "HH:mm:ss", "HH:mm", "HH"};

    public static CastAttempt<LocalTime> attempt(Object object) {
        return CastAttempt.ofNullable(TimeCaster.cast(object, false));
    }

    public static LocalTime cast(Object object) {
        return TimeCaster.cast(object, true);
    }

    public static LocalTime cast(Object object, Boolean fail) {
        return TimeCaster.cast(object, fail, ZoneId.systemDefault());
    }

    public static LocalTime cast(Object object, Boolean fail, ZoneId timezone) {
        if (object == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast null to a LocalTime.");
            }
            return null;
        }
        if ((object = DynamicObject.unWrap(object)) instanceof LocalTime) {
            LocalTime targetDateTime = (LocalTime)object;
            return targetDateTime;
        }
        if (object instanceof DateTime) {
            DateTime targetDateTime = (DateTime)object;
            return targetDateTime.toLocalTime();
        }
        if (object instanceof ZonedDateTime) {
            ZonedDateTime targetZonedDateTime = (ZonedDateTime)object;
            return targetZonedDateTime.toLocalTime();
        }
        if (object instanceof Calendar) {
            Calendar targetCalendar = (Calendar)object;
            return LocalTime.of(targetCalendar.get(11), targetCalendar.get(12), targetCalendar.get(13));
        }
        if (object instanceof LocalDateTime) {
            LocalDateTime targetLocalDateTime = (LocalDateTime)object;
            return targetLocalDateTime.toLocalTime();
        }
        if (object instanceof LocalDate) {
            LocalDate targetLocalDate = (LocalDate)object;
            return LocalTime.of(0, 0, 0);
        }
        if (object instanceof Date) {
            Date targetDate = (Date)object;
            return LocalTime.ofInstant(targetDate.toInstant(), timezone);
        }
        if (object instanceof java.sql.Date) {
            java.sql.Date targetDate = (java.sql.Date)object;
            return LocalTime.of(0, 0, 0);
        }
        if (object instanceof Timestamp) {
            Timestamp targetTimestamp = (Timestamp)object;
            return targetTimestamp.toLocalDateTime().toLocalTime();
        }
        String targetString = StringCaster.attempt(object).getOrDefault(null);
        if (targetString == null) {
            if (fail.booleanValue()) {
                throw new BoxCastException("Can't cast [" + object.toString() + "] to a String.");
            }
            return null;
        }
        for (String format : COMMON_FORMATS) {
            try {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern(format);
                return LocalTime.parse(targetString, formatter);
            }
            catch (DateTimeParseException dateTimeParseException) {
            }
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast [" + String.valueOf(object) + "] to a LocalTime.");
        }
        return null;
    }
}

