/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.casters;

import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.IBoxCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.types.XML;
import ortus.boxlang.runtime.types.exceptions.BoxCastException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class XMLCaster
implements IBoxCaster {
    public static CastAttempt<XML> attempt(Object object) {
        return CastAttempt.ofNullable(XMLCaster.cast(object, false));
    }

    public static XML cast(Object object) {
        return XMLCaster.cast(object, true);
    }

    public static XML cast(Object object, Boolean fail) {
        block8: {
            String oString;
            if (object == null) {
                if (fail.booleanValue()) {
                    throw new BoxCastException("Can't cast null to a XML.");
                }
                return null;
            }
            if ((object = DynamicObject.unWrap(object)) instanceof XML) {
                XML xml = (XML)object;
                return xml;
            }
            if (object instanceof Node) {
                Node node = (Node)object;
                return new XML(node);
            }
            CastAttempt<String> stringCastAttempt = StringCaster.attempt(object);
            if (stringCastAttempt.wasSuccessful() && XMLCaster.XMLSmokeTest(oString = stringCastAttempt.get())) {
                try {
                    return new XML(oString);
                }
                catch (BoxRuntimeException e) {
                    if (e.getCause() != null && e.getCause() instanceof SAXException) break block8;
                    throw e;
                }
            }
        }
        if (fail.booleanValue()) {
            throw new BoxCastException("Can't cast " + object.getClass().getName() + " to XML.");
        }
        return null;
    }

    private static boolean XMLSmokeTest(String xmlData) {
        String trimmed = xmlData.trim();
        return trimmed.startsWith("<") && trimmed.endsWith(">");
    }
}

