/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.dynamic.javaproxy;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.ClassUtils;
import ortus.boxlang.compiler.IBoxpiler;
import ortus.boxlang.compiler.javaboxpiler.JavaBoxpiler;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyDefinition;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.interop.proxies.BaseProxy;
import ortus.boxlang.runtime.interop.proxies.BiConsumer;
import ortus.boxlang.runtime.interop.proxies.BiFunction;
import ortus.boxlang.runtime.interop.proxies.BinaryOperator;
import ortus.boxlang.runtime.interop.proxies.Callable;
import ortus.boxlang.runtime.interop.proxies.Comparator;
import ortus.boxlang.runtime.interop.proxies.Consumer;
import ortus.boxlang.runtime.interop.proxies.Function;
import ortus.boxlang.runtime.interop.proxies.GenericProxy;
import ortus.boxlang.runtime.interop.proxies.IInterceptorLambda;
import ortus.boxlang.runtime.interop.proxies.Predicate;
import ortus.boxlang.runtime.interop.proxies.Runnable;
import ortus.boxlang.runtime.interop.proxies.Supplier;
import ortus.boxlang.runtime.interop.proxies.ToDoubleFunction;
import ortus.boxlang.runtime.interop.proxies.ToIntFunction;
import ortus.boxlang.runtime.interop.proxies.ToLongFunction;
import ortus.boxlang.runtime.interop.proxies.UnaryOperator;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.runnables.IProxyRunnable;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.util.EncryptionUtil;

public class InterfaceProxyService {
    private static final ClassLocator classLocator = BoxRuntime.getInstance().getClassLocator();
    private static final IBoxpiler boxpiler = JavaBoxpiler.getInstance();
    private static final List<String> CORE_PROXIES = Arrays.asList("BiConsumer", "BiFunction", "BinaryOperator", "Callable", "Comparator", "Consumer", "Function", "IInterceptorLambda", "Predicate", "Runnable", "Supplier", "UnaryOperator", "ToDoubleFunction", "ToIntFunction", "ToLongFunction");

    public static IProxyRunnable createProxy(IBoxContext context, IClassRunnable boxClass, Array interfaces) {
        InterfaceProxyDefinition definition = InterfaceProxyService.generateDefinition(context, interfaces);
        DynamicObject proxyClass = DynamicObject.of(boxpiler.compileInterfaceProxy(context, definition));
        proxyClass.invokeConstructor(context);
        IProxyRunnable proxy = (IProxyRunnable)proxyClass.getTargetInstance();
        proxy.setBXProxy(boxClass);
        return proxy;
    }

    public static InterfaceProxyDefinition generateDefinition(IBoxContext context, Array interfaces) {
        String name = InterfaceProxyService.generateName(interfaces);
        ArrayList<Method> methods = new ArrayList<Method>();
        ArrayList<String> interfaceNames = new ArrayList<String>();
        for (Object iface : interfaces) {
            DynamicObject iClass;
            if (iface instanceof Class) {
                Class ic = (Class)iface;
                interfaceNames.add(ic.getName());
                iClass = DynamicObject.of(ic);
            } else {
                iClass = classLocator.load(context, (String)iface, "java", true, context.getCurrentImports());
                interfaceNames.add((String)iface);
            }
            methods.addAll(iClass.getMethods(false));
        }
        return new InterfaceProxyDefinition(name, methods, interfaceNames);
    }

    public static Object buildGenericProxy(IBoxContext context, Object target, String method, Array interfaces, ClassLoader classLoader) {
        Class[] interfacesArray = (Class[])interfaces.stream().map(iface -> {
            if (iface instanceof Class) {
                Class interfaceClass = (Class)iface;
                return interfaceClass;
            }
            return classLocator.load(context, (String)iface, "java", true, context.getCurrentImports()).getTargetClass();
        }).toArray(Class[]::new);
        return InterfaceProxyService.buildGenericProxy(context, target, method, interfacesArray, classLoader);
    }

    public static Object buildGenericProxy(IBoxContext context, Object target, String method, Class<?>[] interfaces, ClassLoader classLoader) {
        return Proxy.newProxyInstance(classLoader, interfaces, (InvocationHandler)new GenericProxy(target, context, method));
    }

    public static BaseProxy buildCoreProxy(Class<?> clazz, IBoxContext context, Object target, String method) {
        String targetName;
        return switch (targetName = clazz.getSimpleName()) {
            case "BiConsumer" -> new BiConsumer(target, context, method);
            case "BiFunction" -> new BiFunction(target, context, method);
            case "BinaryOperator" -> new BinaryOperator(target, context, method);
            case "Callable" -> new Callable(target, context, method);
            case "Comparator" -> new Comparator(target, context, method);
            case "Consumer" -> new Consumer(target, context, method);
            case "Function" -> new Function(target, context, method);
            case "IInterceptorLambda" -> new IInterceptorLambda(target, context, method);
            case "Predicate" -> new Predicate(target, context, method);
            case "Runnable" -> new Runnable(target, context, method);
            case "Supplier" -> new Supplier(target, context, method);
            case "UnaryOperator" -> new UnaryOperator(target, context, method);
            case "ToDoubleFunction" -> new ToDoubleFunction(target, context, method);
            case "ToIntFunction" -> new ToIntFunction(target, context, method);
            case "ToLongFunction" -> new ToLongFunction(target, context, method);
            default -> null;
        };
    }

    public static Boolean isFunctionalInterface(Class<?> clazz) {
        if (clazz.isInterface() && clazz.isAnnotationPresent(FunctionalInterface.class)) {
            return true;
        }
        return InterfaceProxyService.isSAMInterface(clazz);
    }

    public static Boolean isSAMInterface(Class<?> clazz) {
        if (!clazz.isInterface()) {
            return false;
        }
        return Arrays.stream(clazz.getDeclaredMethods()).filter(method -> Modifier.isAbstract(method.getModifiers())).count() == 1L;
    }

    public static Boolean isCoreProxy(String className) {
        return CORE_PROXIES.contains(className);
    }

    public static Class<?> getFunctionalInterface(Class<?> clazz) {
        if (InterfaceProxyService.isFunctionalInterface(clazz).booleanValue()) {
            return clazz;
        }
        return ClassUtils.getAllInterfaces(clazz).stream().filter(InterfaceProxyService::isFunctionalInterface).findFirst().orElse(null);
    }

    private static String generateName(Array interfaces) {
        return EncryptionUtil.hash(interfaces.toString(), "MD5");
    }
}

