/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.events;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.events.IInterceptor;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;

public abstract class BaseInterceptor
implements IInterceptor {
    protected IStruct properties = new Struct();
    protected Logger logger;

    @Override
    public void configure(IStruct properties) {
        this.properties = properties;
        this.logger = LoggerFactory.getLogger(this.getClass());
    }

    @Override
    public void configure() {
        this.configure(new Struct());
    }

    public IStruct getProperties() {
        return this.properties;
    }

    public Object getProperty(Key name) {
        return this.properties.get(name);
    }

    public Object getProperty(Key name, Object defaultValue) {
        return this.properties.getOrDefault(name, defaultValue);
    }

    public boolean hasProperty(Key name) {
        return this.properties.containsKey(name);
    }

    public IInterceptor setProperty(Key name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public BoxRuntime getRuntime() {
        return BoxRuntime.getInstance();
    }

    public void unregister() {
        this.getRuntime().getInterceptorService().unregister(DynamicObject.of(this));
    }
}

