/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.events;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.events.IInterceptor;
import ortus.boxlang.runtime.events.IInterceptorLambda;
import ortus.boxlang.runtime.events.InterceptionPoint;
import ortus.boxlang.runtime.events.InterceptorState;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.modules.ModuleRecord;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class InterceptorPool {
    private static final Logger logger = LoggerFactory.getLogger(InterceptorPool.class);
    protected Set<Key> interceptionPoints = ConcurrentHashMap.newKeySet(32);
    protected Map<Key, InterceptorState> interceptionStates = new ConcurrentHashMap<Key, InterceptorState>();
    protected ConcurrentHashMap<String, Key> keyRegistry = new ConcurrentHashMap();
    protected Key name;
    protected BoxRuntime runtime;

    public InterceptorPool(Key name, BoxRuntime runtime) {
        this.name = name;
        this.runtime = runtime;
    }

    public InterceptorPool(String name, BoxRuntime runtime) {
        this(Key.of(name), runtime);
    }

    public Key getName() {
        return this.name;
    }

    public Set<Key> getInterceptionPoints() {
        return this.interceptionPoints;
    }

    public Map<Key, InterceptorState> getInterceptionStates() {
        return this.interceptionStates;
    }

    public void clearInterceptionStates() {
        this.interceptionStates.clear();
    }

    public Set<String> getInterceptionPointsNames() {
        return this.interceptionPoints.stream().map(Key::getName).collect(Collectors.toSet());
    }

    public Boolean hasInterceptionPoint(Key interceptionPoint) {
        return this.interceptionPoints.contains(interceptionPoint);
    }

    public synchronized InterceptorPool registerInterceptionPoint(Key ... points) {
        this.interceptionPoints.addAll(Arrays.asList(points));
        return this;
    }

    public synchronized InterceptorPool removeInterceptionPoint(Key ... points) {
        this.interceptionPoints.removeAll(Arrays.asList(points));
        this.interceptionStates.keySet().removeAll(Arrays.asList(points));
        return this;
    }

    public InterceptorState getState(Key name) {
        return this.interceptionStates.get(name);
    }

    public Boolean hasState(Key name) {
        return this.interceptionStates.containsKey(name);
    }

    public synchronized InterceptorState registerState(Key name) {
        this.registerInterceptionPoint(name);
        return this.interceptionStates.computeIfAbsent(name, InterceptorState::new);
    }

    public synchronized InterceptorPool removeState(Key name) {
        this.interceptionStates.remove(name);
        return this;
    }

    public IClassRunnable newAndRegister(String clazz, IStruct properties, String name, ModuleRecord moduleRecord) {
        IBoxContext context = this.runtime.getRuntimeContext();
        Optional<ClassLocator.ClassLocation> classLocation = this.runtime.getClassLocator().getBoxResolver().resolve(context, clazz);
        if (!classLocation.isPresent()) {
            throw new BoxRuntimeException("Interceptor class [" + clazz + "] not found locally or with any mappings");
        }
        IClassRunnable oInterceptor = (IClassRunnable)DynamicObject.of(classLocation.get().clazz()).invokeConstructor(context).getTargetInstance();
        oInterceptor.getVariablesScope().put(Key._NAME, (Object)name);
        oInterceptor.getVariablesScope().put(Key.properties, (Object)properties);
        oInterceptor.getVariablesScope().put(Key.log, (Object)LoggerFactory.getLogger(oInterceptor.getClass()));
        oInterceptor.getVariablesScope().put(Key.interceptorService, (Object)this);
        oInterceptor.getVariablesScope().put(Key.boxRuntime, (Object)this.runtime);
        if (moduleRecord != null) {
            oInterceptor.getVariablesScope().put(Key.moduleRecord, (Object)moduleRecord);
        }
        if (oInterceptor.getThisScope().containsKey(Key.configure)) {
            oInterceptor.dereferenceAndInvoke(context, Key.configure, new Object[0], (Boolean)false);
        }
        this.register(oInterceptor);
        return oInterceptor;
    }

    public InterceptorPool register(IInterceptor interceptor) {
        return this.register(interceptor, new Struct());
    }

    public InterceptorPool register(IInterceptor interceptor, IStruct properties) {
        interceptor.configure(properties);
        DynamicObject target = DynamicObject.of(interceptor);
        Set<Key> states = target.getMethodsAsStream(true).filter(method -> method.isAnnotationPresent(InterceptionPoint.class)).map(method -> Key.of(method.getName())).collect(Collectors.toSet());
        return this.register(target, states.toArray(new Key[0]));
    }

    public InterceptorPool register(IClassRunnable interceptor) {
        IStruct metadata = interceptor.getBoxMeta().getMeta();
        Key[] states = (Key[])metadata.getAsArray(Key.functions).stream().map(IStruct.class::cast).filter(function -> function.getAsStruct(Key.annotations).containsKey(Key.interceptionPoint) || this.interceptionPoints.contains(function.getAsKey(Key.nameAsKey))).map(function -> function.getAsKey(Key.nameAsKey)).toArray(Key[]::new);
        if (states.length > 0) {
            this.register(DynamicObject.of(interceptor), states);
        }
        return this;
    }

    public InterceptorPool register(DynamicObject interceptor, Key ... states) {
        Arrays.stream(states).forEach(state -> this.registerState((Key)state).register(interceptor));
        return this;
    }

    public InterceptorPool register(IInterceptorLambda interceptor, Key ... states) {
        Arrays.stream(states).forEach(state -> this.registerState((Key)state).register(DynamicObject.of(interceptor)));
        return this;
    }

    public InterceptorPool unregister(DynamicObject interceptor, Key ... states) {
        Arrays.stream(states).forEach(state -> {
            if (this.hasState((Key)state).booleanValue()) {
                this.getState((Key)state).unregister(interceptor);
            }
        });
        return this;
    }

    public InterceptorPool unregister(DynamicObject interceptor) {
        this.interceptionStates.values().stream().forEach(state -> state.unregister(interceptor));
        return this;
    }

    public void announce(Key state) {
        this.announce(state, (IStruct)new Struct());
    }

    public void announce(BoxEvent state) {
        this.announce(state.key(), (IStruct)new Struct());
    }

    public void announce(BoxEvent state, IStruct data) {
        this.announce(state.key(), data);
    }

    public void announce(String state, IStruct data) {
        this.announce(this.keyRegistry.computeIfAbsent(state, Key::of), data);
    }

    public void announce(Key state, IStruct data) {
        this.announce(state, data, this.runtime.getRuntimeContext());
    }

    public void announce(Key state, IStruct data, IBoxContext context) {
        if (this.hasState(state).booleanValue()) {
            try {
                this.getState(state).announce(data, context);
            }
            catch (Exception e) {
                String errorMessage = String.format("Errors announcing [%s] interception", state.getName());
                logger.error(errorMessage, e);
                throw new BoxRuntimeException(errorMessage, e);
            }
        }
    }

    public CompletableFuture<IStruct> announceAsync(Key state) {
        return this.announceAsync(state, (IStruct)new Struct());
    }

    public CompletableFuture<IStruct> announceAsync(BoxEvent state) {
        return this.announceAsync(state.key(), (IStruct)new Struct());
    }

    public CompletableFuture<IStruct> announceAsync(BoxEvent state, IStruct data) {
        return this.announceAsync(state.key(), data);
    }

    public CompletableFuture<IStruct> announceAsync(String state, IStruct data) {
        return this.announceAsync(this.keyRegistry.computeIfAbsent(state, Key::of), data);
    }

    public CompletableFuture<IStruct> announceAsync(Key state, IStruct data) {
        return this.announceAsync(state, data, this.runtime.getRuntimeContext());
    }

    public CompletableFuture<IStruct> announceAsync(Key state, IStruct data, IBoxContext context) {
        if (this.hasState(state).booleanValue()) {
            return CompletableFuture.supplyAsync(() -> {
                try {
                    this.getState(state).announce(data, context);
                    return data;
                }
                catch (Exception e) {
                    String errorMessage = String.format("Errors announcing [%s] interception", state.getName());
                    logger.error(errorMessage, e);
                    throw new BoxRuntimeException(errorMessage, e);
                }
            });
        }
        return null;
    }
}

