/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.events;

import java.util.ArrayList;
import java.util.List;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.events.IInterceptorLambda;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.IStruct;

public class InterceptorState {
    private Key name;
    private List<DynamicObject> observers = new ArrayList<DynamicObject>();

    public InterceptorState(String name) {
        this(Key.of(name));
    }

    public InterceptorState(Key name) {
        this.name = name;
    }

    public Key getName() {
        return this.name;
    }

    public InterceptorState register(DynamicObject observer) {
        this.observers.add(observer);
        return this;
    }

    public InterceptorState unregister(DynamicObject observer) {
        this.observers.remove(observer);
        return this;
    }

    public Boolean exists(DynamicObject observer) {
        return this.observers.contains(observer);
    }

    public int size() {
        return this.observers.size();
    }

    public void announce(IStruct data, IBoxContext context) {
        if (this.observers.isEmpty()) {
            return;
        }
        Object[] args = new Object[]{data};
        for (DynamicObject observer : this.observers) {
            Object stopChain;
            Object unwrappedObject = observer.unWrap();
            if (unwrappedObject instanceof IReferenceable) {
                IReferenceable castedObserver = (IReferenceable)unwrappedObject;
                stopChain = castedObserver.dereferenceAndInvoke(context, this.getName(), args, (Boolean)false);
            } else if (unwrappedObject instanceof IInterceptorLambda) {
                IInterceptorLambda castedLambda = (IInterceptorLambda)unwrappedObject;
                stopChain = castedLambda.intercept(data);
            } else {
                stopChain = observer.invoke(context, this.getName().getName(), args);
            }
            if (stopChain == null || !BooleanCaster.cast(stopChain).booleanValue()) continue;
            break;
        }
    }
}

