/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.interceptors;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import ortus.boxlang.compiler.parser.ParsingResult;
import ortus.boxlang.runtime.events.BaseInterceptor;
import ortus.boxlang.runtime.events.InterceptionPoint;
import ortus.boxlang.runtime.types.IStruct;

public class ASTCapture
extends BaseInterceptor {
    private boolean toConsole = false;
    private boolean toFile = false;
    private final Path filePath = Paths.get("./grapher/data/", new String[0]);

    public ASTCapture(boolean toConsole, boolean toFile) {
        this.toConsole = toConsole;
        this.toFile = toFile;
    }

    @InterceptionPoint
    public void onParse(IStruct data) {
        ParsingResult result = (ParsingResult)data.get("result");
        if (result.getRoot() != null && (this.toConsole || this.toFile)) {
            String JSON2 = result.getRoot().toJSON();
            if (this.toConsole) {
                System.out.println("==================== AST ====================");
                System.out.println(JSON2);
                System.out.println("=============================================");
            }
            if (this.toFile) {
                Path file = this.filePath.resolve("lastAST.json");
                try {
                    Files.createDirectories(file.getParent(), new FileAttribute[0]);
                    if (Files.exists(file, new LinkOption[0])) {
                        Path backupFile = this.filePath.resolve("prevAST.json");
                        Files.copy(file, backupFile, StandardCopyOption.REPLACE_EXISTING);
                    }
                    Files.writeString(file, (CharSequence)JSON2, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }
}

