/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.interceptors;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.Configurator;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Map;
import java.util.ServiceLoader;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.events.BaseInterceptor;
import ortus.boxlang.runtime.events.InterceptionPoint;
import ortus.boxlang.runtime.logging.LoggingConfigurator;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Argument;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;

public class Logging
extends BaseInterceptor {
    private final String logsDirectory;
    private Struct appendersMap = new Struct();
    private Argument[] logArguments = new Argument[]{new Argument(true, "string", Key.text), new Argument(false, "string", Key.file), new Argument(false, "string", Key.log, "Application"), new Argument(false, "string", Key.type, "Information")};
    private static final String LEVEL_TRACE = "trace";
    private static final String LEVEL_DEBUG = "debug";
    private static final String LEVEL_INFO = "info";
    private static final String LEVEL_WARN = "warn";
    private static final String LEVEL_ERROR = "error";
    private static final Map<Key, String> levelMap = Map.of(Key.of("Trace"), "trace", Key.of("Debug"), "debug", Key.of("Debugging"), "debug", Key.of("Info"), "info", Key.of("Information"), "info", Key.of("Warning"), "warn", Key.of("Warn"), "warn", Key.of("Error"), "error", Key.of("Fatal"), "error");

    public Logging(BoxRuntime instance) {
        this.logsDirectory = instance.getConfiguration().logsDirectory;
    }

    @InterceptionPoint
    public void logMessage(IStruct data) {
        block26: {
            FileAppender<ILoggingEvent> fileAppender;
            block27: {
                Key levelKey;
                String logText = data.getAsString(Key.text);
                Object file = data.getAsString(Key.file);
                String logCategory = data.getAsString(Key.log);
                String logLevel = data.getAsString(Key.level);
                String logType = data.getAsString(Key.type);
                if (logCategory == null) {
                    logCategory = "BoxRuntime";
                }
                if (logType != null) {
                    logLevel = logType;
                }
                if (!levelMap.containsKey(levelKey = Key.of(logLevel))) {
                    throw new BoxRuntimeException(String.format("[%s] is not a valid logging level.", logLevel));
                }
                fileAppender = null;
                Logger logger2 = null;
                try {
                    if (file == null) {
                        file = logCategory + ".log";
                    }
                    String filePath = Path.of((String)file, new String[0]).isAbsolute() ? Path.of((String)file, new String[0]).normalize().toString() : Paths.get(this.logsDirectory, new String[]{"/", file}).normalize().toString();
                    LoggerContext logContext = null;
                    ILoggerFactory loggerFactory = LoggerFactory.getILoggerFactory();
                    if (loggerFactory instanceof LoggerContext) {
                        logContext = (LoggerContext)loggerFactory;
                    } else {
                        loggerFactory.getLogger(this.getClass().getName()).warn("The LoggerFactory context is not an instance of Logback LoggerContext. Recevied class: " + loggerFactory.getClass().getName());
                        LoggingConfigurator configurator = ServiceLoader.load(Configurator.class, BoxRuntime.class.getClassLoader()).stream().map(ServiceLoader.Provider::get).map(target -> (LoggingConfigurator)target).findFirst().orElse(null);
                        logContext = configurator.getLoggerContext();
                        if (logContext == null) {
                            logContext = new LoggerContext();
                            logContext.start();
                            configurator.configure(logContext);
                        }
                    }
                    logger2 = logContext.getLogger(logCategory);
                    logger2.setLevel(Level.ALL);
                    logger2.setAdditive(true);
                    fileAppender = new FileAppender<ILoggingEvent>();
                    fileAppender.setFile(filePath);
                    fileAppender.setEncoder(LoggingConfigurator.encoder);
                    fileAppender.setContext(logContext);
                    fileAppender.setAppend(true);
                    fileAppender.setImmediateFlush(true);
                    fileAppender.setPrudent(true);
                    fileAppender.start();
                    logger2.addAppender((Appender<ILoggingEvent>)fileAppender);
                    switch (levelMap.get(levelKey)) {
                        case "trace": {
                            logger2.trace(logText);
                            break;
                        }
                        case "debug": {
                            logger2.debug(logText);
                            break;
                        }
                        default: {
                            logContext.getLogger("ROOT").info(logText);
                            logger2.info(logText);
                            break;
                        }
                        case "warn": {
                            logger2.warn(logText);
                            break;
                        }
                        case "error": {
                            logger2.error(logText);
                        }
                    }
                    if (fileAppender == null) break block26;
                    if (logger2 == null) break block27;
                    logger2.detachAppender((Appender<ILoggingEvent>)fileAppender);
                }
                catch (Exception e) {
                    try {
                        throw new BoxRuntimeException("An error occurred while attempting to log the message", e);
                    }
                    catch (Throwable throwable) {
                        if (fileAppender != null) {
                            if (logger2 != null) {
                                logger2.detachAppender((Appender<ILoggingEvent>)fileAppender);
                            }
                            fileAppender.stop();
                        }
                        throw throwable;
                    }
                }
            }
            fileAppender.stop();
        }
    }

    @InterceptionPoint
    public void onRuntimeShutdown() {
        this.appendersMap.keySet().stream().forEach(key -> ((FileAppender)this.appendersMap.get(key)).stop());
    }

    public void onRuntimeShutdown(IStruct data) {
        this.onRuntimeShutdown();
    }
}

