/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.interop;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.invoke.CallSite;
import java.lang.invoke.ConstantCallSite;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.bifs.MemberDescriptor;
import ortus.boxlang.runtime.context.ClassBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.dynamic.casters.BooleanCaster;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.GenericCaster;
import ortus.boxlang.runtime.dynamic.casters.StringCaster;
import ortus.boxlang.runtime.dynamic.casters.StructCasterLoose;
import ortus.boxlang.runtime.dynamic.javaproxy.InterfaceProxyService;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.interop.DynamicObject;
import ortus.boxlang.runtime.interop.MethodRecord;
import ortus.boxlang.runtime.loader.ClassLocator;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.IntKey;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.FunctionService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.IType;
import ortus.boxlang.runtime.types.JavaMethod;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.AbstractClassException;
import ortus.boxlang.runtime.types.exceptions.BoxLangException;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.ExceptionUtil;
import ortus.boxlang.runtime.types.exceptions.KeyNotFoundException;
import ortus.boxlang.runtime.types.exceptions.NoConstructorException;
import ortus.boxlang.runtime.types.exceptions.NoFieldException;
import ortus.boxlang.runtime.types.exceptions.NoMethodException;
import ortus.boxlang.runtime.types.meta.BoxMeta;
import ortus.boxlang.runtime.types.meta.GenericMeta;
import ortus.boxlang.runtime.types.util.ListUtil;
import ortus.boxlang.runtime.types.util.ObjectRef;

public class DynamicInteropService {
    public static final Class<ClassUtils> CLASS_UTILS = ClassUtils.class;
    private static final Set<Key> exceptionKeys = new HashSet<Key>(Arrays.asList(BoxLangException.messageKey, BoxLangException.detailKey, BoxLangException.typeKey, BoxLangException.tagContextKey, BoxRuntimeException.ExtendedInfoKey, Key.stackTrace, Key.cause));
    private static final Map<Class<?>, Class<?>> PRIMITIVE_MAP;
    private static final Map<Class<?>, Class<?>> WRAPPERS_MAP;
    private static final MethodHandles.Lookup METHOD_LOOKUP;
    private static final ConcurrentHashMap<String, MethodRecord> methodHandleCache;
    private static Key lengthKey;
    public static final Object[] EMPTY_ARGS;
    private static Boolean handlesCacheEnabled;
    private static ClassLocator classLocator;
    private static FunctionService functionService;
    private static List<String> numberTargets;
    private static List<String> booleanTargets;

    public static Boolean isHandlesCacheEnabled() {
        return handlesCacheEnabled;
    }

    public static void setHandlesCacheEnabled(Boolean enabled) {
        handlesCacheEnabled = enabled;
    }

    public static <T> T invokeConstructor(IBoxContext context, Class<T> targetClass, Object ... args) {
        MethodHandle constructorHandle;
        Object[] BLArgs = null;
        boolean noInit = false;
        if (DynamicInteropService.isInterface(targetClass)) {
            throw new BoxRuntimeException("Cannot invoke a constructor on an interface: " + targetClass.getName());
        }
        if (IClassRunnable.class.isAssignableFrom(targetClass)) {
            if (args.length == 1 && args[0].equals(Key.noInit)) {
                noInit = true;
            } else {
                BLArgs = args;
            }
            args = EMPTY_ARGS;
        }
        DynamicInteropService.unWrapArguments(args);
        try {
            constructorHandle = METHOD_LOOKUP.unreflectConstructor(DynamicInteropService.findMatchingConstructor(context, targetClass, DynamicInteropService.argumentsToClasses(args), args));
        }
        catch (IllegalAccessException e) {
            throw new BoxRuntimeException("Error getting constructor for class " + targetClass.getName() + " with arguments classes " + Arrays.toString(DynamicInteropService.argumentsToClasses(args)), e);
        }
        ConstantCallSite callSite = new ConstantCallSite(constructorHandle);
        MethodHandle constructorInvoker = ((CallSite)callSite).dynamicInvoker();
        try {
            Object thisInstance = constructorInvoker.invokeWithArguments(args);
            if (thisInstance instanceof IClassRunnable) {
                IClassRunnable boxClass = (IClassRunnable)thisInstance;
                return DynamicInteropService.bootstrapBLClass(context, boxClass, BLArgs, null, noInit);
            }
            BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.AFTER_DYNAMIC_OBJECT_CREATION, Struct.of(new Object[]{Key.object, thisInstance, Key.clazz, targetClass}));
            return (T)thisInstance;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error invoking constructor for class " + targetClass.getName(), e);
        }
    }

    public static <T> T invokeConstructor(IBoxContext context, Class<T> targetClass, Map<Key, Object> args) {
        MethodHandle constructorHandle;
        if (DynamicInteropService.isInterface(targetClass)) {
            throw new BoxRuntimeException("Cannot invoke a constructor on an interface");
        }
        if (!IClassRunnable.class.isAssignableFrom(targetClass)) {
            throw new BoxRuntimeException("Cannot use named arguments on a Java constructor.");
        }
        MethodType constructorType = MethodType.methodType(Void.TYPE, DynamicInteropService.argumentsToClasses(EMPTY_ARGS));
        try {
            constructorHandle = METHOD_LOOKUP.findConstructor(targetClass, constructorType);
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            throw new BoxRuntimeException("Error getting constructor for class " + targetClass.getName(), e);
        }
        ConstantCallSite callSite = new ConstantCallSite(constructorHandle);
        MethodHandle constructorInvoker = ((CallSite)callSite).dynamicInvoker();
        try {
            Object thisInstance = constructorInvoker.invokeWithArguments(EMPTY_ARGS);
            if (thisInstance instanceof IClassRunnable) {
                IClassRunnable boxClass = (IClassRunnable)thisInstance;
                return DynamicInteropService.bootstrapBLClass(context, boxClass, null, args, false);
            }
            return (T)thisInstance;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error invoking constructor for class " + targetClass.getName(), e);
        }
    }

    public static <T> T invokeConstructor(IBoxContext context, Class<T> targetClass) {
        return DynamicInteropService.invokeConstructor(context, targetClass, EMPTY_ARGS);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T bootstrapBLClass(IBoxContext context, IClassRunnable boxClass, Object[] positionalArgs, Map<Key, Object> namedArgs, boolean noInit) {
        ClassBoxContext classContext = new ClassBoxContext(context, boxClass);
        classContext.pushTemplate(boxClass);
        try {
            Iterator<Map.Entry<Key, Object>> thisInterface;
            String superClassName;
            Object superClassObject = boxClass.getAnnotations().get(Key._EXTENDS);
            if (superClassObject != null && (superClassName = StringCaster.cast(superClassObject)) != null && superClassName.length() > 0 && !superClassName.toLowerCase().startsWith("java:")) {
                IClassRunnable _super = (IClassRunnable)DynamicInteropService.getClassLocator().load((IBoxContext)classContext, superClassName, classContext.getCurrentImports()).invokeConstructor((IBoxContext)classContext, Key.noInit).unWrapBoxLangClass();
                if (_super.getAnnotations().get(Key._final) != null) {
                    throw new BoxRuntimeException("Cannot extend final class: " + String.valueOf(_super.getName()));
                }
                boxClass.setSuper(_super);
            }
            boxClass.pseudoConstructor(classContext);
            Object oInterfaces = boxClass.getAnnotations().get(Key._IMPLEMENTS);
            if (oInterfaces != null) {
                List<String> interfaceNames = ListUtil.asList(StringCaster.cast(oInterfaces), ",").stream().map(String::valueOf).map(String::trim).filter(name -> !name.toLowerCase().startsWith("java:")).toList();
                for (String interfaceName : interfaceNames) {
                    thisInterface = (BoxInterface)DynamicInteropService.getClassLocator().load((IBoxContext)classContext, interfaceName, classContext.getCurrentImports()).unWrapBoxLangClass();
                    boxClass.registerInterface((BoxInterface)((Object)thisInterface));
                }
            }
            if (!noInit) {
                Object initMethod;
                Key initKey;
                if (boxClass.getAnnotations().get(Key._ABSTRACT) != null) {
                    throw new AbstractClassException("Cannot instantiate an abstract class: " + String.valueOf(boxClass.getName()));
                }
                if (boxClass.getSuper() != null) {
                    BoxClassSupport.validateAbstractMethods(boxClass, boxClass.getSuper().getAllAbstractMethods());
                }
                if (boxClass.dereference(context, initKey = (initMethod = boxClass.getAnnotations().get(Key.initMethod)) != null ? Key.of(StringCaster.cast(initMethod)) : Key.init, true) != null) {
                    Object result = positionalArgs != null ? boxClass.dereferenceAndInvoke((IBoxContext)classContext, initKey, positionalArgs, (Boolean)false) : boxClass.dereferenceAndInvoke((IBoxContext)classContext, initKey, namedArgs, (Boolean)false);
                    if (result != null) {
                        thisInterface = result;
                        return (T)thisInterface;
                    }
                } else {
                    if (positionalArgs != null && positionalArgs.length == 1 && (thisInterface = positionalArgs[0]) instanceof IStruct) {
                        IStruct named = (IStruct)((Object)thisInterface);
                        namedArgs = named;
                    } else if (positionalArgs != null && positionalArgs.length > 0) {
                        throw new BoxRuntimeException("Implicit constructor only accepts named args or a single Struct as a positional arg.");
                    }
                    if (namedArgs != null) {
                        if (namedArgs.containsKey(Key.argumentCollection) && (thisInterface = namedArgs.get(Key.argumentCollection)) instanceof IStruct) {
                            IStruct argCollection = (IStruct)((Object)thisInterface);
                            namedArgs = new HashMap<Key, Object>(namedArgs);
                            for (Map.Entry<Key, Object> entry : argCollection.entrySet()) {
                                if (namedArgs.containsKey(entry.getKey())) continue;
                                namedArgs.put(entry.getKey(), entry.getValue());
                            }
                            namedArgs.remove(Key.argumentCollection);
                        }
                        for (Map.Entry<Key, Object> entry : namedArgs.entrySet()) {
                            boxClass.dereferenceAndInvoke((IBoxContext)classContext, Key.of("set" + entry.getKey().getName()), new Object[]{entry.getValue()}, (Boolean)false);
                        }
                    }
                }
            }
        }
        finally {
            classContext.flushBuffer(false);
            classContext.popTemplate();
        }
        return (T)boxClass;
    }

    public static Object invoke(IBoxContext context, Class<?> targetClass, String methodName, Boolean safe, Object ... arguments) {
        return DynamicInteropService.invoke(context, targetClass, null, methodName, safe, arguments);
    }

    public static Object invoke(IBoxContext context, Object targetInstance, String methodName, Boolean safe, Object ... arguments) {
        return DynamicInteropService.invoke(context, targetInstance.getClass(), targetInstance, methodName, safe, arguments);
    }

    public static Object invoke(IBoxContext context, Class<?> targetClass, Object targetInstance, String methodName, Boolean safe, Object ... arguments) {
        return DynamicInteropService.invoke(context, null, targetClass, targetInstance, methodName, safe, arguments);
    }

    public static Object invoke(IBoxContext context, DynamicObject dynamicObject, Class<?> targetClass, Object targetInstance, String methodName, Boolean safe, Object ... arguments) {
        MethodRecord methodRecord;
        if (methodName == null || methodName.isEmpty()) {
            throw new BoxRuntimeException("Method name cannot be null or empty.");
        }
        DynamicInteropService.unWrapArguments(arguments);
        Class<?>[] argumentClasses = DynamicInteropService.argumentsToClasses(arguments);
        try {
            methodRecord = DynamicInteropService.getMethodHandle(context, dynamicObject, targetClass, targetInstance, methodName, argumentClasses, arguments);
            targetInstance = dynamicObject == null ? targetInstance : dynamicObject.getTargetInstance();
        }
        catch (RuntimeException e) {
            if (safe.booleanValue()) {
                return null;
            }
            e.printStackTrace();
            throw new BoxRuntimeException("Error getting method " + methodName + " for class " + targetClass.getName(), e);
        }
        if (!methodRecord.isStatic() && targetInstance == null && dynamicObject != null) {
            try {
                targetInstance = DynamicInteropService.invokeConstructor(context, targetClass);
                dynamicObject.setTargetInstance(targetInstance);
            }
            catch (NoConstructorException e) {
                throw new BoxRuntimeException("No instance provided for non-static method " + methodName + " for class " + targetClass.getName() + " and there is not an no-arg constructor to call.");
            }
        }
        try {
            DynamicInteropService.coerceArguments(context, methodRecord.method().getParameterTypes(), argumentClasses, arguments, methodRecord.method().isVarArgs());
            return methodRecord.isStatic() ? methodRecord.methodHandle().invokeWithArguments(arguments) : methodRecord.methodHandle().bindTo(targetInstance).invokeWithArguments(arguments);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error invoking method " + methodName + " for class " + targetClass.getName(), e);
        }
    }

    public static Object invokeStatic(IBoxContext context, DynamicObject dynamicObject, Class<?> targetClass, String methodName, Object ... arguments) {
        if (methodName == null || methodName.isEmpty()) {
            throw new BoxRuntimeException("Method name cannot be null or empty.");
        }
        DynamicInteropService.unWrapArguments(arguments);
        Class<?>[] argumentClasses = DynamicInteropService.argumentsToClasses(arguments);
        MethodRecord methodRecord = DynamicInteropService.getMethodHandle(context, dynamicObject, targetClass, null, methodName, argumentClasses, arguments);
        DynamicInteropService.coerceArguments(context, methodRecord.method().getParameterTypes(), argumentClasses, arguments, methodRecord.method().isVarArgs());
        try {
            return methodRecord.methodHandle().invokeWithArguments(arguments);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error invoking method " + methodName + " for class " + targetClass.getName(), e);
        }
    }

    public static Optional<Object> getField(Class<?> targetClass, String fieldName) {
        return DynamicInteropService.getField(targetClass, null, fieldName);
    }

    public static Optional<Object> getField(Object targetInstance, String fieldName) {
        return DynamicInteropService.getField(targetInstance.getClass(), targetInstance, fieldName);
    }

    public static Optional<Object> getField(Class<?> targetClass, Object targetInstance, String fieldName) {
        MethodHandle fieldHandle;
        Field field = DynamicInteropService.findField(targetClass, fieldName);
        try {
            if (targetInstance != null && !field.getDeclaringClass().equals(targetInstance.getClass()) && targetInstance instanceof IClassRunnable) {
                IClassRunnable boxClass = (IClassRunnable)targetInstance;
                fieldHandle = boxClass.lookupPrivateField(field);
            } else {
                fieldHandle = METHOD_LOOKUP.unreflectGetter(field);
            }
        }
        catch (IllegalAccessException e) {
            throw new BoxRuntimeException("Error getting field " + fieldName + " for class " + targetClass.getName(), e);
        }
        Boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (!isStatic.booleanValue() && targetInstance == null) {
            throw new BoxRuntimeException("You are trying to get a public field but there is not instance set on the invoker, please make sure the [invokeConstructor] has been called.");
        }
        try {
            return Optional.ofNullable(isStatic != false ? fieldHandle.invoke() : fieldHandle.invoke(targetInstance));
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error getting field " + fieldName + " for class " + targetClass.getName(), e);
        }
    }

    public static Optional<Object> getField(Object targetInstance, String fieldName, Object defaultValue) {
        return DynamicInteropService.getField(targetInstance.getClass(), fieldName, defaultValue);
    }

    public static Optional<Object> getField(Class<?> targetClass, String fieldName, Object defaultValue) {
        return DynamicInteropService.getField(targetClass, null, fieldName, defaultValue);
    }

    public static Optional<Object> getField(Class<?> targetClass, Object targetInstance, String fieldName, Object defaultValue) {
        try {
            return DynamicInteropService.getField(targetClass, targetInstance, fieldName);
        }
        catch (BoxLangException e) {
            return Optional.ofNullable(defaultValue);
        }
    }

    public static void setField(Class<?> targetClass, String fieldName, Object value) {
        DynamicInteropService.setField(targetClass, null, fieldName, value);
    }

    public static void setField(Object targetInstance, String fieldName, Object value) {
        DynamicInteropService.setField(targetInstance.getClass(), targetInstance, fieldName, value);
    }

    public static void setField(Class<?> targetClass, Object targetInstance, String fieldName, Object value) {
        MethodHandle fieldHandle;
        Field field = DynamicInteropService.findField(targetClass, fieldName);
        try {
            fieldHandle = METHOD_LOOKUP.unreflectSetter(field);
        }
        catch (IllegalAccessException e) {
            throw new BoxRuntimeException("Error setting field " + fieldName + " for class " + targetClass.getName(), e);
        }
        Boolean isStatic = Modifier.isStatic(field.getModifiers());
        if (!isStatic.booleanValue() && targetInstance == null) {
            throw new BoxRuntimeException("You are trying to set a public field but there is not instance set on the invoker, please make sure the [invokeConstructor] has been called.");
        }
        try {
            if (isStatic.booleanValue()) {
                fieldHandle.invokeWithArguments(value);
            } else {
                fieldHandle.bindTo(targetInstance).invokeWithArguments(value);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BoxRuntimeException("Error setting field " + fieldName + " for class " + targetClass.getName(), e);
        }
    }

    public static Field findField(Class<?> targetClass, String fieldName) {
        return DynamicInteropService.getFieldsAsStream(targetClass).filter(target -> target.getName().equalsIgnoreCase(fieldName)).findFirst().orElseThrow(() -> new NoFieldException(String.format("No such field [%s] found in the class [%s].", fieldName, targetClass.getName())));
    }

    public static Boolean hasField(Class<?> targetClass, String fieldName) {
        return DynamicInteropService.getFieldNames(targetClass).contains(fieldName);
    }

    public static Boolean hasFieldNoCase(Class<?> targetClass, String fieldName) {
        return DynamicInteropService.getFieldNamesNoCase(targetClass).contains(fieldName.toUpperCase());
    }

    public static Field[] getFields(Class<?> targetClass) {
        HashSet<Field> allFields = new HashSet<Field>();
        allFields.addAll(new HashSet<Field>(List.of(targetClass.getFields())));
        allFields.addAll(new HashSet<Field>(List.of(targetClass.getDeclaredFields())));
        return allFields.toArray(new Field[0]);
    }

    public static Stream<Field> getFieldsAsStream(Class<?> targetClass) {
        return Stream.of(DynamicInteropService.getFields(targetClass));
    }

    public static List<String> getFieldNames(Class<?> targetClass) {
        return DynamicInteropService.getFieldsAsStream(targetClass).map(Field::getName).toList();
    }

    public static List<String> getFieldNamesNoCase(Class<?> targetClass) {
        return DynamicInteropService.getFieldsAsStream(targetClass).map(Field::getName).map(String::toUpperCase).toList();
    }

    public static Class<?> findClass(Class<?> targetClass, String className) {
        return DynamicInteropService.getClassesAsStream(targetClass).filter(target -> target.getSimpleName().equalsIgnoreCase(className)).findFirst().orElseThrow(() -> new NoFieldException(String.format("No such inner class [%s] found in the class [%s].", className, targetClass.getName())));
    }

    public static Boolean hasClass(Class<?> targetClass, String className) {
        return DynamicInteropService.getClassNames(targetClass).contains(className);
    }

    public static Boolean hasClassNoCase(Class<?> targetClass, String className) {
        return DynamicInteropService.getClassNamesNoCase(targetClass).contains(className.toUpperCase());
    }

    public static Class<?>[] getClasses(Class<?> targetClass) {
        return targetClass.getClasses();
    }

    public static Stream<Class<?>> getClassesAsStream(Class<?> targetClass) {
        return Stream.of(DynamicInteropService.getClasses(targetClass));
    }

    public static List<String> getClassNames(Class<?> targetClass) {
        return DynamicInteropService.getClassesAsStream(targetClass).map(Class::getSimpleName).toList();
    }

    public static List<String> getClassNamesNoCase(Class<?> targetClass) {
        return DynamicInteropService.getClassesAsStream(targetClass).map(Class::getSimpleName).map(String::toUpperCase).toList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodRecord getMethodHandle(IBoxContext context, DynamicObject dynamicObject, Class<?> targetClass, Object targetInstance, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        String cacheKey = targetClass.hashCode() + methodName + Arrays.hashCode(argumentsAsClasses);
        MethodRecord methodRecord = methodHandleCache.get(cacheKey);
        if (methodRecord == null || !handlesCacheEnabled.booleanValue()) {
            String string = cacheKey.intern();
            synchronized (string) {
                if (methodRecord == null || !handlesCacheEnabled.booleanValue()) {
                    methodRecord = DynamicInteropService.discoverMethodHandle(context, dynamicObject, targetClass, targetInstance, methodName, argumentsAsClasses, arguments);
                    methodHandleCache.put(cacheKey, methodRecord);
                }
            }
        }
        return methodRecord;
    }

    public static MethodRecord discoverMethodHandle(IBoxContext context, DynamicObject dynamicObject, Class<?> targetClass, Object targetInstance, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        Method targetMethod = DynamicInteropService.findMatchingMethod(context, targetClass, methodName, argumentsAsClasses, arguments);
        if (!Modifier.isStatic(targetMethod.getModifiers()) && targetInstance == null && dynamicObject != null) {
            try {
                targetInstance = DynamicInteropService.invokeConstructor(context, targetClass);
                dynamicObject.setTargetInstance(targetInstance);
            }
            catch (NoConstructorException e) {
                throw new BoxRuntimeException("No instance provided for non-static method " + methodName + " for class " + targetClass.getName() + " and there is not an no-arg constructor to call.");
            }
        }
        try {
            targetMethod = DynamicInteropService.checkAccess(context, targetClass, targetInstance, targetMethod, methodName, argumentsAsClasses, arguments);
        }
        catch (NoMethodException e) {
            throw new BoxRuntimeException("Error checking method access" + methodName + " for class " + targetClass.getName(), e);
        }
        if (targetMethod == null) {
            throw new NoMethodException(String.format("No such method [%s] found in the class [%s] using [%d] arguments of types [%s]", methodName, targetClass.getName(), argumentsAsClasses.length, Arrays.toString(argumentsAsClasses)));
        }
        try {
            MethodHandle targetHandle;
            if (targetInstance != null && !targetMethod.getDeclaringClass().equals(targetInstance.getClass()) && targetInstance instanceof IClassRunnable) {
                IClassRunnable boxClass = (IClassRunnable)targetInstance;
                targetHandle = boxClass.lookupPrivateMethod(targetMethod);
            } else {
                targetHandle = METHOD_LOOKUP.unreflect(targetMethod);
            }
            return new MethodRecord(methodName, targetMethod, targetHandle, Modifier.isStatic(targetMethod.getModifiers()), argumentsAsClasses.length);
        }
        catch (IllegalAccessException e) {
            throw new BoxRuntimeException("Error building MethodRecord for " + methodName + " for class " + targetClass.getName(), e);
        }
    }

    public static Set<Constructor<?>> getConstructors(Class<?> targetClass) {
        HashSet allConstructors = new HashSet();
        allConstructors.addAll(new HashSet(List.of(targetClass.getConstructors())));
        allConstructors.addAll(new HashSet(List.of(targetClass.getDeclaredConstructors())));
        return allConstructors;
    }

    public static Stream<Constructor<?>> getConstructorsAsStream(Class<?> targetClass) {
        return DynamicInteropService.getConstructors(targetClass).stream();
    }

    public static Constructor<?> findMatchingConstructor(IBoxContext context, Class<?> targetClass, Class<?>[] argumentsAsClasses, Object ... arguments) {
        return DynamicInteropService.getConstructorsAsStream(targetClass).filter(constructor -> DynamicInteropService.constructorHasMatchingParameterTypes(context, constructor, argumentsAsClasses, arguments)).findFirst().orElseThrow(() -> new NoConstructorException(String.format("No such constructor found in the class [%s] using [%d] arguments of types [%s]", targetClass.getName(), argumentsAsClasses.length, Arrays.toString(argumentsAsClasses))));
    }

    private static Method checkAccess(IBoxContext context, Class<?> targetClass, Object targetInstance, Method targetMethod, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        boolean isStatic;
        if (targetMethod != null && !targetMethod.canAccess((isStatic = Modifier.isStatic(targetMethod.getModifiers())) ? null : targetInstance)) {
            Method methodByInterface = DynamicInteropService.findMatchingMethodByInterfaces(context, targetClass, methodName, argumentsAsClasses, arguments);
            if (methodByInterface != null) {
                return methodByInterface;
            }
            Class<?> superClass = targetClass.getSuperclass();
            targetMethod = DynamicInteropService.findMatchingMethod(context, superClass, methodName, argumentsAsClasses, arguments);
            return DynamicInteropService.checkAccess(context, superClass, targetInstance, targetMethod, methodName, argumentsAsClasses, arguments);
        }
        return targetMethod;
    }

    public static Set<Method> getMethods(Class<?> targetClass, Boolean callable) {
        Set<Method> allMethods = new HashSet<Method>();
        Collections.addAll(allMethods, targetClass.getMethods());
        Collections.addAll(allMethods, targetClass.getDeclaredMethods());
        if (Boolean.TRUE.equals(callable)) {
            allMethods = allMethods.stream().filter(method -> Modifier.isPublic(method.getModifiers())).collect(Collectors.toSet());
        }
        return allMethods;
    }

    public static Stream<Method> getMethodsAsStream(Class<?> targetClass, Boolean callable) {
        return DynamicInteropService.getMethods(targetClass, callable).stream();
    }

    public static Method getMethod(Class<?> targetClass, String name, Boolean callable) {
        return ((Stream)DynamicInteropService.getMethodsAsStream(targetClass, callable).parallel()).filter(method -> method.getName().equalsIgnoreCase(name)).findFirst().orElseThrow(() -> new NoMethodException(String.format("No such method [%s] found in the class [%s].", name, targetClass.getName())));
    }

    public static List<String> getMethodNames(Class<?> targetClass, Boolean callable) {
        return ((Stream)DynamicInteropService.getMethodsAsStream(targetClass, callable).parallel()).map(Method::getName).toList();
    }

    public static List<String> getMethodNamesNoCase(Class<?> targetClass, Boolean callable) {
        return ((Stream)DynamicInteropService.getMethodsAsStream(targetClass, callable).parallel()).map(Method::getName).map(String::toUpperCase).toList();
    }

    public static Boolean hasMethod(Class<?> targetClass, String methodName) {
        return DynamicInteropService.getMethodNames(targetClass, true).contains(methodName);
    }

    public static Boolean hasMethodNoCase(Class<?> targetClass, String methodName) {
        return DynamicInteropService.getMethodNamesNoCase(targetClass, true).contains(methodName.toUpperCase());
    }

    public static Method findMatchingMethod(IBoxContext context, Class<?> targetClass, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        List<Method> targetMethods = DynamicInteropService.getMethodsAsStream(targetClass, true).filter(method -> method.getName().equalsIgnoreCase(methodName)).filter(method -> {
            if (!method.isVarArgs() && method.getParameterCount() == argumentsAsClasses.length) {
                return true;
            }
            if (method.isVarArgs()) {
                return argumentsAsClasses.length >= method.getParameterCount() - 1;
            }
            return false;
        }).toList();
        if (targetMethods.isEmpty()) {
            return null;
        }
        Method foundMethod = targetMethods.stream().filter(method -> DynamicInteropService.hasMatchingParameterTypes(context, method, true, argumentsAsClasses, arguments)).findFirst().orElse(null);
        if (foundMethod == null) {
            foundMethod = targetMethods.stream().filter(method -> DynamicInteropService.hasMatchingParameterTypes(context, method, false, argumentsAsClasses, arguments)).findFirst().orElse(null);
        }
        return foundMethod;
    }

    public static Method findMatchingMethodByInterfaces(IBoxContext context, Class<?> targetClass, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        Class<?>[] interfaces = targetClass.getInterfaces();
        return Arrays.stream(interfaces).map(interfaceClass -> DynamicInteropService.findMatchingMethod(context, interfaceClass, methodName, argumentsAsClasses, arguments)).filter(Objects::nonNull).findFirst().orElse(null);
    }

    public static MethodHandle toMethodHandle(Method method) {
        try {
            return METHOD_LOOKUP.unreflect(method);
        }
        catch (IllegalAccessException e) {
            throw new BoxRuntimeException("Error creating MethodHandle for method [" + String.valueOf(method) + "]", e);
        }
    }

    public static Class<?> argumentToClass(Object thisArg) {
        if (thisArg == null) {
            return null;
        }
        Class<?> clazz = thisArg.getClass();
        return PRIMITIVE_MAP.getOrDefault(clazz, clazz);
    }

    public static Class<?>[] argumentsToClasses(Object ... args) {
        return (Class[])Arrays.stream(args).map(DynamicObject::argumentToClass).toArray(Class[]::new);
    }

    public static Object unWrap(Object param) {
        if (param instanceof DynamicObject) {
            DynamicObject invoker = (DynamicObject)param;
            if (invoker.hasInstance().booleanValue()) {
                return invoker.getTargetInstance();
            }
            return invoker.getTargetClass();
        }
        return param;
    }

    private static void unWrapArguments(Object[] arguments) {
        for (int j = 0; j < arguments.length; ++j) {
            arguments[j] = DynamicInteropService.unWrap(arguments[j]);
        }
    }

    public static Object dereference(IBoxContext context, Class<?> targetClass, Key name, Boolean safe) {
        return DynamicInteropService.dereference(context, targetClass, null, name, safe);
    }

    public static Object dereference(IBoxContext context, Object targetInstance, Key name, Boolean safe) {
        return DynamicInteropService.dereference(context, targetInstance.getClass(), targetInstance, name, safe);
    }

    public static Object dereference(IBoxContext context, Class<?> targetClass, Object targetInstance, Key name, Boolean safe) {
        IStruct struct;
        if (IReferenceable.class.isAssignableFrom(targetClass) && targetInstance != null && targetInstance instanceof IReferenceable) {
            IReferenceable ref = (IReferenceable)((Object)targetInstance);
            return ref.dereference(context, name, safe);
        }
        if (name.equals(BoxMeta.key)) {
            if (targetInstance != null && targetInstance instanceof IType) {
                IType type = (IType)((Object)targetInstance);
                return type.getBoxMeta();
            }
            return new GenericMeta(targetInstance != null ? targetInstance : targetClass);
        }
        if (Map.class.isAssignableFrom(targetClass) && targetInstance instanceof Map) {
            return ((Map)((Object)targetInstance)).get(name.getOriginalValue());
        }
        if (targetInstance instanceof List) {
            List list = (List)((Object)targetInstance);
            Integer index = Array.validateAndGetIntForDereference(name, list.size(), safe);
            if (safe.booleanValue() && (index < 1 || index > list.size())) {
                return null;
            }
            return list.get(index - 1);
        }
        if (targetInstance != null && targetInstance.getClass().isArray()) {
            Object[] arr = (Object[])targetInstance;
            if (name.equals(lengthKey)) {
                return arr.length;
            }
            Integer index = Array.validateAndGetIntForDereference(name, arr.length, safe);
            if (safe.booleanValue() && (index < 1 || index > arr.length)) {
                return null;
            }
            return arr[index - 1];
        }
        if (targetInstance instanceof Throwable) {
            Throwable t = (Throwable)((Object)targetInstance);
            if (exceptionKeys.contains(name)) {
                if (name.equals(BoxLangException.messageKey)) {
                    return t.getMessage();
                }
                if (name.equals(Key.cause)) {
                    return t.getCause();
                }
                if (name.equals(Key.stackTrace)) {
                    StringWriter sw = new StringWriter();
                    PrintWriter pw = new PrintWriter(sw);
                    t.printStackTrace(pw);
                    return sw.toString();
                }
                if (name.equals(BoxLangException.tagContextKey)) {
                    return ExceptionUtil.buildTagContext(t);
                }
                if (targetInstance instanceof BoxLangException) {
                    BoxLangException ble = (BoxLangException)((Object)targetInstance);
                    if (name.equals(BoxLangException.detailKey)) {
                        return ble.getDetail();
                    }
                    if (name.equals(BoxLangException.typeKey)) {
                        return ble.getType();
                    }
                    if (ble instanceof BoxRuntimeException) {
                        BoxRuntimeException bre = (BoxRuntimeException)ble;
                        if (name.equals(BoxRuntimeException.ExtendedInfoKey)) {
                            return bre.getExtendedInfo();
                        }
                    }
                    return "";
                }
                return "";
            }
        }
        if (targetInstance instanceof String) {
            String s = (String)((Object)targetInstance);
            if (name instanceof IntKey) {
                IntKey intKey = (IntKey)name;
                Integer index = Array.validateAndGetIntForDereference(intKey, s.length(), safe);
                if (safe.booleanValue() && (index < 1 || index > s.length())) {
                    return null;
                }
                return s.substring(index - 1, index);
            }
        }
        if (DynamicInteropService.hasFieldNoCase(targetClass, name.getName()).booleanValue()) {
            return DynamicInteropService.getField(targetClass, targetInstance, name.getName()).orElse(null);
        }
        if (DynamicInteropService.hasClassNoCase(targetClass, name.getName()).booleanValue()) {
            return DynamicObject.of(DynamicInteropService.findClass(targetClass, name.getName()));
        }
        if (targetClass.isEnum()) {
            return Enum.valueOf(targetClass, name.getName());
        }
        if (DynamicInteropService.getMethodNamesNoCase(targetClass, true).contains(name.getName().toUpperCase())) {
            return new JavaMethod(name, new DynamicObject(targetClass).setTargetInstance(targetInstance));
        }
        CastAttempt<IStruct> structAttempt = StructCasterLoose.attempt(targetInstance != null ? targetInstance : targetClass);
        if (structAttempt.wasSuccessful() && (struct = structAttempt.get()).containsKey(name)) {
            return struct.get(name);
        }
        if (safe.booleanValue()) {
            return null;
        }
        if (targetInstance != null) {
            throw new KeyNotFoundException(String.format("The instance [%s] has no public field or inner class [%s]. The allowed fields are [%s]", ClassUtils.getCanonicalName(targetClass), name.getName(), DynamicInteropService.getFieldNames(targetClass)));
        }
        throw new KeyNotFoundException(String.format("The instance [%s] has no static field or inner class [%s]. The allowed fields are [%s]", ClassUtils.getCanonicalName(targetClass), name.getName(), DynamicInteropService.getFieldNames(targetClass)));
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Class<?> targetClass, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        return DynamicInteropService.dereferenceAndInvoke(dynamicObject, targetClass, null, context, name, positionalArguments, safe);
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Object targetInstance, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        return DynamicInteropService.dereferenceAndInvoke(dynamicObject, targetInstance.getClass(), targetInstance, context, name, positionalArguments, safe);
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Class<?> targetClass, Object targetInstance, IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        if (IReferenceable.class.isAssignableFrom(targetClass) && targetInstance != null && targetInstance instanceof IReferenceable) {
            IReferenceable ref = (IReferenceable)targetInstance;
            return ref.dereferenceAndInvoke(context, name, positionalArguments, safe);
        }
        if (targetInstance != null) {
            ObjectRef ref = ObjectRef.of(targetInstance);
            MemberDescriptor memberDescriptor = DynamicInteropService.getFunctionService().getMemberMethod(context, name, ref);
            if (memberDescriptor != null) {
                targetInstance = ref.get();
                return memberDescriptor.invoke(context, targetInstance, positionalArguments);
            }
        }
        if (safe.booleanValue() && !DynamicInteropService.hasMethod(targetClass, name.getName()).booleanValue()) {
            return null;
        }
        if (name.equals(Key.getClass)) {
            return targetClass;
        }
        return DynamicInteropService.invoke(context, dynamicObject, targetClass, targetInstance, name.getName(), safe, positionalArguments);
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Class<?> targetClass, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        return DynamicInteropService.dereferenceAndInvoke(dynamicObject, targetClass, null, context, name, namedArguments, safe);
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Object targetInstance, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        return DynamicInteropService.dereferenceAndInvoke(dynamicObject, targetInstance.getClass(), targetInstance, context, name, namedArguments, safe);
    }

    public static Object dereferenceAndInvoke(DynamicObject dynamicObject, Class<?> targetClass, Object targetInstance, IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        if (IReferenceable.class.isAssignableFrom(targetClass) && targetInstance != null && targetInstance instanceof IReferenceable) {
            IReferenceable ref = (IReferenceable)targetInstance;
            return ref.dereferenceAndInvoke(context, name, namedArguments, safe);
        }
        if (targetInstance != null) {
            ObjectRef ref = ObjectRef.of(targetInstance);
            MemberDescriptor memberDescriptor = DynamicInteropService.getFunctionService().getMemberMethod(context, name, ref);
            if (memberDescriptor != null) {
                targetInstance = ref.get();
                return memberDescriptor.invoke(context, targetInstance, namedArguments);
            }
        }
        throw new BoxRuntimeException("Methods on Java objects cannot be called with named arguments");
    }

    public static Object assign(IBoxContext context, Class<?> targetClass, Key name, Object value) {
        return DynamicInteropService.assign(context, targetClass, null, name, value);
    }

    public static Object assign(IBoxContext context, Object targetInstance, Key name, Object value) {
        return DynamicInteropService.assign(context, targetInstance.getClass(), targetInstance, name, value);
    }

    public static Object assign(IBoxContext context, Class<?> targetClass, Object targetInstance, Key name, Object value) {
        if (IReferenceable.class.isAssignableFrom(targetClass) && targetInstance != null && targetInstance instanceof IReferenceable) {
            IReferenceable ref = (IReferenceable)targetInstance;
            return ref.assign(context, name, value);
        }
        if (targetInstance != null && targetInstance.getClass().isArray()) {
            Object[] arr = (Object[])targetInstance;
            Integer index = Array.validateAndGetIntForAssign(name, arr.length, true);
            arr[index.intValue() - 1] = value;
            return value;
        }
        if (targetInstance instanceof List) {
            List list = (List)targetInstance;
            Integer index = Array.validateAndGetIntForAssign(name, list.size(), false);
            if (index > list.size()) {
                for (int i = list.size(); i < index; ++i) {
                    list.add(null);
                }
            }
            list.set(index - 1, value);
            return value;
        }
        if (targetInstance instanceof Map) {
            ((Map)targetInstance).put(name.getOriginalValue(), value);
            return value;
        }
        try {
            DynamicInteropService.setField(targetClass, targetInstance, name.getName(), value);
        }
        catch (Throwable e) {
            if (targetInstance instanceof Throwable) {
                return value;
            }
            throw e;
        }
        return value;
    }

    public static boolean isInterface(Class<?> targetClass) {
        return targetClass.isInterface() || BoxInterface.class.isAssignableFrom(targetClass);
    }

    private static boolean hasMatchingParameterTypes(IBoxContext context, Method method, Boolean exact, Class<?>[] argumentsAsClasses, Object ... arguments) {
        Class<?>[] methodParams = method.getParameterTypes();
        if (ClassUtils.isAssignable(argumentsAsClasses, methodParams)) {
            return true;
        }
        if (!exact.booleanValue()) {
            return DynamicInteropService.coerceArguments(context, methodParams, argumentsAsClasses, arguments, method.isVarArgs());
        }
        return false;
    }

    private static Boolean coerceArguments(IBoxContext context, Class<?>[] methodParams, Class<?>[] argumentsAsClasses, Object[] arguments, Boolean isVarArgs) {
        boolean coerced = false;
        for (int i = 0; i < methodParams.length && i < arguments.length; ++i) {
            Object object;
            if (arguments[i] == null) {
                coerced = true;
                continue;
            }
            if (methodParams[i].isAssignableFrom(arguments[i].getClass())) {
                coerced = true;
                continue;
            }
            if (isVarArgs.booleanValue() && i == methodParams.length - 1 && (object = arguments[i]) instanceof Array) {
                Array castedArray = (Array)object;
                Class<?> varArgType = WRAPPERS_MAP.getOrDefault(methodParams[i].getComponentType(), methodParams[i].getComponentType());
                arguments[i] = castedArray.toVarArgsArray(varArgType);
                coerced = true;
                continue;
            }
            Optional<?> attempt = DynamicInteropService.coerceAttempt(context, methodParams[i], argumentsAsClasses[i], arguments[i], isVarArgs);
            if (attempt.isPresent()) {
                coerced = true;
                arguments[i] = attempt.get();
                continue;
            }
            coerced = false;
            break;
        }
        return coerced;
    }

    private static Optional<?> coerceAttempt(IBoxContext context, Class<?> expected, Class<?> actual, Object value, Boolean isVarArgs) {
        String expectedClass = expected.getSimpleName().toLowerCase();
        String actualClass = actual.getSimpleName().toLowerCase();
        expected = WRAPPERS_MAP.getOrDefault(expected, expected);
        actual = WRAPPERS_MAP.getOrDefault(actual, actual);
        if (Number.class.isAssignableFrom(expected) && Number.class.isAssignableFrom(actual)) {
            return Optional.of(GenericCaster.cast(context, value, expectedClass));
        }
        if (Boolean.class.isAssignableFrom(expected) && booleanTargets.contains(actualClass) && Number.class.isAssignableFrom(actual)) {
            return Optional.of(BooleanCaster.cast(value));
        }
        if (expectedClass.equals("string")) {
            return Optional.of(StringCaster.cast(value));
        }
        Class<?> functionalInterface = InterfaceProxyService.getFunctionalInterface(expected);
        if (functionalInterface != null && (value instanceof IClassRunnable || value instanceof Function)) {
            return Optional.of(InterfaceProxyService.isCoreProxy(expected.getSimpleName()) != false ? InterfaceProxyService.buildCoreProxy(functionalInterface, context, value, null) : InterfaceProxyService.buildGenericProxy(context, value, null, new Class[]{functionalInterface}, functionalInterface.getClassLoader()));
        }
        if (functionalInterface != null && functionalInterface.isAssignableFrom(value.getClass())) {
            return Optional.of(value);
        }
        return Optional.empty();
    }

    private static boolean constructorHasMatchingParameterTypes(IBoxContext context, Constructor<?> constructor, Class<?>[] argumentsAsClasses, Object ... arguments) {
        Class<?>[] constructorParams = constructor.getParameterTypes();
        if (constructorParams.length != argumentsAsClasses.length) {
            return false;
        }
        return ClassUtils.isAssignable(argumentsAsClasses, constructorParams);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static FunctionService getFunctionService() {
        if (functionService != null) return functionService;
        Class<DynamicInteropService> clazz = DynamicInteropService.class;
        synchronized (DynamicInteropService.class) {
            if (functionService != null) return functionService;
            functionService = BoxRuntime.getInstance().getFunctionService();
            // ** MonitorExit[var0] (shouldn't be in output)
            return functionService;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static ClassLocator getClassLocator() {
        if (classLocator != null) return classLocator;
        Class<DynamicInteropService> clazz = DynamicInteropService.class;
        synchronized (DynamicInteropService.class) {
            if (classLocator != null) return classLocator;
            classLocator = BoxRuntime.getInstance().getClassLocator();
            // ** MonitorExit[var0] (shouldn't be in output)
            return classLocator;
        }
    }

    static {
        methodHandleCache = new ConcurrentHashMap(32);
        lengthKey = Key.of("length");
        EMPTY_ARGS = new Object[0];
        handlesCacheEnabled = true;
        classLocator = null;
        functionService = null;
        numberTargets = List.of("boolean", "byte", "character", "string");
        booleanTargets = List.of("string", "character");
        METHOD_LOOKUP = MethodHandles.lookup();
        PRIMITIVE_MAP = Map.of(Boolean.class, Boolean.TYPE, Byte.class, Byte.TYPE, Character.class, Character.TYPE, Short.class, Short.TYPE, Integer.class, Integer.TYPE, Long.class, Long.TYPE, Float.class, Float.TYPE, Double.class, Double.TYPE);
        WRAPPERS_MAP = Map.of(Boolean.TYPE, Boolean.class, Byte.TYPE, Byte.class, Character.TYPE, Character.class, Short.TYPE, Short.class, Integer.TYPE, Integer.class, Long.TYPE, Long.class, Float.TYPE, Float.class, Double.TYPE, Double.class);
    }
}

