/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.interop;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.apache.commons.lang3.ClassUtils;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.IReferenceable;
import ortus.boxlang.runtime.interop.DynamicInteropService;
import ortus.boxlang.runtime.runnables.BoxClassSupport;
import ortus.boxlang.runtime.runnables.BoxInterface;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;

public class DynamicObject
implements IReferenceable,
Serializable {
    public static final Class<ClassUtils> CLASS_UTILS = ClassUtils.class;
    public static final Object[] EMPTY_ARGS = new Object[0];
    private Class<?> targetClass;
    private Object targetInstance = null;
    private static final long serialVersionUID = 1L;

    public DynamicObject(Class<?> targetClass) {
        this.targetClass = targetClass;
    }

    public DynamicObject(Class<?> targetClass, IBoxContext context) {
        this.targetClass = targetClass;
        if (BoxInterface.class.isAssignableFrom(targetClass)) {
            this.targetInstance = this.invoke(context, "getInstance", context);
        }
    }

    public DynamicObject(Object targetInstance) {
        this.targetInstance = targetInstance;
        this.targetClass = targetInstance.getClass();
    }

    public static DynamicObject of(Class<?> targetClass, IBoxContext context) {
        return new DynamicObject(targetClass, context);
    }

    public static DynamicObject of(Class<?> targetClass) {
        return new DynamicObject(targetClass);
    }

    public static DynamicObject of(Object targetInstance) {
        return new DynamicObject(targetInstance);
    }

    public Class<?> getTargetClass() {
        return this.targetClass;
    }

    public DynamicObject setTargetClass(Class<?> targetClass) {
        this.targetClass = targetClass;
        return this;
    }

    public Object getTargetInstance() {
        return this.targetInstance;
    }

    public DynamicObject setTargetInstance(Object targetInstance) {
        this.targetInstance = targetInstance;
        return this;
    }

    public DynamicObject invokeConstructor(IBoxContext context, Object ... args) {
        this.targetInstance = DynamicInteropService.invokeConstructor(context, this.targetClass, args);
        return this;
    }

    public DynamicObject invokeConstructor(IBoxContext context, Map<Key, Object> args) {
        this.targetInstance = DynamicInteropService.invokeConstructor(context, this.targetClass, args);
        return this;
    }

    public DynamicObject invokeConstructor(IBoxContext context) {
        return this.invokeConstructor(context, EMPTY_ARGS);
    }

    public Object invoke(IBoxContext context, String methodName, Object ... arguments) {
        return DynamicInteropService.invoke(context, this, this.getTargetClass(), this.getTargetInstance(), methodName, false, arguments);
    }

    public Object invokeStatic(IBoxContext context, String methodName, Object ... arguments) {
        return DynamicInteropService.invoke(context, this, this.targetClass, null, methodName, false, arguments);
    }

    public Optional<Object> getField(String fieldName) {
        return DynamicInteropService.getField(this.targetClass, this.targetInstance, fieldName);
    }

    public Optional<Object> getField(String fieldName, Object defaultValue) {
        return DynamicInteropService.getField(this.targetClass, this.targetInstance, fieldName, defaultValue);
    }

    public DynamicObject setField(String fieldName, Object value) {
        DynamicInteropService.setField(this.targetClass, this.targetInstance, fieldName, value);
        return this;
    }

    public Field findField(String fieldName) {
        return DynamicInteropService.findField(this.targetClass, fieldName);
    }

    public Boolean hasField(String fieldName) {
        return DynamicInteropService.hasField(this.targetClass, fieldName);
    }

    public Boolean hasFieldNoCase(String fieldName) {
        return DynamicInteropService.hasFieldNoCase(this.targetClass, fieldName);
    }

    public Field[] getFields() {
        return DynamicInteropService.getFields(this.targetClass);
    }

    public Stream<Field> getFieldsAsStream() {
        return DynamicInteropService.getFieldsAsStream(this.targetClass);
    }

    public List<String> getFieldNames() {
        return DynamicInteropService.getFieldNames(this.targetClass);
    }

    public List<String> getFieldNamesNoCase() {
        return DynamicInteropService.getFieldNamesNoCase(this.targetClass);
    }

    public Method getMethod(String name, Boolean callable) {
        return DynamicInteropService.getMethod(this.targetClass, name, callable);
    }

    public Set<Method> getMethods(Boolean callable) {
        return DynamicInteropService.getMethods(this.targetClass, callable);
    }

    public Stream<Method> getMethodsAsStream(Boolean callable) {
        return DynamicInteropService.getMethodsAsStream(this.targetClass, callable);
    }

    public List<String> getMethodNames(Boolean callable) {
        return DynamicInteropService.getMethodNames(this.targetClass, callable);
    }

    public List<String> getMethodNamesNoCase(Boolean callable) {
        return DynamicInteropService.getMethodNamesNoCase(this.targetClass, callable);
    }

    public Boolean hasMethod(String methodName) {
        return DynamicInteropService.hasMethod(this.targetClass, methodName);
    }

    public Boolean hasMethodNoCase(String methodName) {
        return DynamicInteropService.hasMethodNoCase(this.targetClass, methodName);
    }

    public Method findMatchingMethod(IBoxContext context, String methodName, Class<?>[] argumentsAsClasses, Object ... arguments) {
        return DynamicInteropService.findMatchingMethod(context, this.targetClass, methodName, argumentsAsClasses, arguments);
    }

    public static MethodHandle toMethodHandle(Method method) {
        return DynamicInteropService.toMethodHandle(method);
    }

    public boolean isInterface() {
        return DynamicInteropService.isInterface(this.targetClass);
    }

    public static Class<?> argumentToClass(Object thisArg) {
        return DynamicInteropService.argumentToClass(thisArg);
    }

    public static Class<?>[] argumentsToClasses(Object ... args) {
        return DynamicInteropService.argumentsToClasses(args);
    }

    public static Object unWrap(Object param) {
        return DynamicInteropService.unWrap(param);
    }

    public Object unWrap() {
        if (this.hasInstance().booleanValue()) {
            return this.getTargetInstance();
        }
        return this.getTargetClass();
    }

    public Object unWrapBoxLangClass() {
        if (this.hasInstance().booleanValue() && (this.getTargetInstance() instanceof IClassRunnable || this.getTargetInstance() instanceof BoxInterface)) {
            return this.getTargetInstance();
        }
        return this;
    }

    public Boolean hasInstance() {
        return this.targetInstance != null;
    }

    @Override
    public Object dereference(IBoxContext context, Key name, Boolean safe) {
        if (IClassRunnable.class.isAssignableFrom(this.targetClass) && this.targetInstance == null) {
            return BoxClassSupport.dereferenceStatic(this, context, name, safe);
        }
        return DynamicInteropService.dereference(context, this.targetClass, this.targetInstance, name, safe);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Object[] positionalArguments, Boolean safe) {
        if (name.equals(Key.init)) {
            this.targetInstance = DynamicInteropService.invokeConstructor(context, this.targetClass, positionalArguments);
            return this.targetInstance;
        }
        if (IClassRunnable.class.isAssignableFrom(this.targetClass) && this.targetInstance == null) {
            return BoxClassSupport.dereferenceAndInvokeStatic(this, context, name, positionalArguments, safe);
        }
        return DynamicInteropService.dereferenceAndInvoke(this, this.targetClass, this.targetInstance, context, name, positionalArguments, safe);
    }

    @Override
    public Object dereferenceAndInvoke(IBoxContext context, Key name, Map<Key, Object> namedArguments, Boolean safe) {
        if (IClassRunnable.class.isAssignableFrom(this.targetClass) && this.targetInstance == null) {
            return BoxClassSupport.dereferenceAndInvokeStatic(this, context, name, namedArguments, safe);
        }
        return DynamicInteropService.dereferenceAndInvoke(this, this.targetClass, this.targetInstance, context, name, namedArguments, safe);
    }

    @Override
    public Object assign(IBoxContext context, Key name, Object value) {
        if (IClassRunnable.class.isAssignableFrom(this.targetClass) && this.targetInstance == null) {
            return BoxClassSupport.assignStatic(this, context, name, value);
        }
        return DynamicInteropService.assign(context, this.targetClass, this.targetInstance, name, value);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (obj instanceof DynamicObject) {
            DynamicObject other = (DynamicObject)obj;
            if (this.targetClass != null && other.targetClass != null) {
                return this.targetClass.equals(other.targetClass);
            }
            if (this.targetInstance != null && other.targetInstance != null) {
                return this.targetInstance.equals(other.targetInstance);
            }
        }
        if (obj instanceof Class && this.targetClass != null) {
            return this.targetClass.equals(obj);
        }
        if (this.targetInstance != null) {
            return this.targetInstance.equals(obj);
        }
        return false;
    }

    public int hashCode() {
        if (this.targetClass != null) {
            return this.targetClass.hashCode();
        }
        if (this.targetInstance != null) {
            return this.targetInstance.hashCode();
        }
        return 0;
    }
}

