/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.interop.proxies;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.runnables.IClassRunnable;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Function;
import ortus.boxlang.runtime.util.RequestThreadManager;

public abstract class BaseProxy {
    protected Object target;
    protected Key defaultMethod;
    protected IBoxContext context;
    protected ApplicationBoxContext appContext;
    protected Logger logger;
    protected RequestThreadManager threadManager;

    protected BaseProxy(Object target, IBoxContext context, String method) {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        if (!(target instanceof Function) && !(target instanceof IClassRunnable)) {
            throw new IllegalArgumentException("Target must be a Function or IClassRunnable");
        }
        this.target = target;
        this.defaultMethod = method != null && !method.isEmpty() ? Key.of(method) : Key.run;
        this.context = context;
        this.appContext = context.getParentOfType(ApplicationBoxContext.class);
        this.threadManager = new RequestThreadManager();
        this.prepLogger(BaseProxy.class);
    }

    protected BaseProxy(Object target, IBoxContext context) {
        this(target, context, "run");
    }

    protected Object invoke(Key method, Object ... args) {
        return this.getDynamicTarget().dereferenceAndInvoke(this.context, method, args, (Boolean)false);
    }

    protected Object invoke(Object ... args) {
        if (this.isFunctionTarget().booleanValue()) {
            return this.context.invokeFunction(this.target, args);
        }
        return this.getDynamicTarget().dereferenceAndInvoke(this.context, this.defaultMethod, args, (Boolean)false);
    }

    protected Boolean isFunctionTarget() {
        return this.target instanceof Function;
    }

    protected Boolean isClassRunnableTarget() {
        return this.target instanceof IClassRunnable;
    }

    protected Function getAsFunction() {
        return (Function)this.target;
    }

    protected IClassRunnable getDynamicTarget() {
        return (IClassRunnable)this.target;
    }

    protected Key getDefaultMethod() {
        return this.defaultMethod;
    }

    protected void prepLogger(Class<?> clazz) {
        this.logger = LoggerFactory.getLogger(clazz);
    }

    protected Logger getLogger() {
        return this.logger;
    }

    protected Thread getCurrentThread() {
        return Thread.currentThread();
    }

    protected String getCurrentThreadName() {
        return Thread.currentThread().getName();
    }

    protected boolean isInForkJoinPool() {
        return this.getCurrentThread().getName().startsWith("ForkJoinPool");
    }

    protected RequestThreadManager getThreadManager() {
        return this.threadManager;
    }

    protected boolean isInThread() {
        return this.threadManager.isInThread();
    }
}

