/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.Connection;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.jdbc.ITransaction;
import ortus.boxlang.runtime.scopes.Key;

public class ChildTransaction
implements ITransaction {
    private static final Logger logger = LoggerFactory.getLogger(ChildTransaction.class);
    private ITransaction parent;
    private final String savepointPrefix;
    private static final Key BEGIN = Key.of("BEGIN");
    private static final Key END = Key.of("END");
    private static final Key COMMIT = Key.of("COMMIT");

    public ChildTransaction(ITransaction parent) {
        this.parent = parent;
        this.savepointPrefix = "CHILD_" + UUID.randomUUID().toString() + "_";
    }

    @Override
    public ChildTransaction setIsolationLevel(int isolationLevel) {
        logger.warn("Cannot set isolation level on a nested transaction. No action required; this nested transaction will use the isolation level defined by the parent");
        return this;
    }

    @Override
    public int getIsolationLevel() {
        return this.parent.getIsolationLevel();
    }

    @Override
    public Connection getConnection() {
        return this.parent.getConnection();
    }

    @Override
    public ChildTransaction setDataSource(DataSource datasource) {
        logger.warn("Cannot set datasource on a nested transaction. No action required; this nested transaction will use the datasource defined by the parent");
        return this;
    }

    @Override
    public DataSource getDataSource() {
        return this.parent.getDataSource();
    }

    @Override
    public ChildTransaction begin() {
        this.setSavepoint(BEGIN);
        return this;
    }

    @Override
    public ChildTransaction commit() {
        this.setSavepoint(COMMIT);
        return this;
    }

    @Override
    public ChildTransaction rollback() {
        return this.rollback(Key.nulls);
    }

    @Override
    public ChildTransaction rollback(Key savepoint) {
        if (savepoint == Key.nulls) {
            savepoint = BEGIN;
        }
        logger.debug("Rolling back child transaction to savepoint {}", (Object)(this.savepointPrefix + String.valueOf(savepoint)));
        this.parent.rollback(Key.of(this.savepointPrefix + savepoint.getNameNoCase()));
        return this;
    }

    @Override
    public ChildTransaction setSavepoint(Key savepoint) {
        this.parent.setSavepoint(Key.of(this.savepointPrefix + savepoint.getNameNoCase()));
        return this;
    }

    @Override
    public ChildTransaction end() {
        this.setSavepoint(END);
        return this;
    }

    public ITransaction getParent() {
        return this.parent;
    }
}

