/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.segments.DatasourceConfig;
import ortus.boxlang.runtime.context.ApplicationBoxContext;
import ortus.boxlang.runtime.context.IBoxContext;
import ortus.boxlang.runtime.dynamic.casters.CastAttempt;
import ortus.boxlang.runtime.dynamic.casters.StructCaster;
import ortus.boxlang.runtime.jdbc.ChildTransaction;
import ortus.boxlang.runtime.jdbc.DataSource;
import ortus.boxlang.runtime.jdbc.ITransaction;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.jdbc.Transaction;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.DatasourceService;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;

public class ConnectionManager {
    private static final Logger logger = LoggerFactory.getLogger(ConnectionManager.class);
    private ITransaction transaction;
    private IBoxContext context;
    private DataSource defaultDatasource = null;
    private Map<Key, DataSource> datasources = new ConcurrentHashMap<Key, DataSource>();
    private DatasourceService datasourceService = BoxRuntime.getInstance().getDataSourceService();

    public ConnectionManager(IBoxContext context) {
        this.context = context;
    }

    public boolean isInTransaction() {
        return this.transaction != null;
    }

    public ITransaction getTransaction() {
        return this.transaction;
    }

    public ITransaction getTransactionOrThrow() {
        if (!this.isInTransaction()) {
            throw new DatabaseException("Transaction is not started; Please place this method call inside a transaction{} block");
        }
        return this.getTransaction();
    }

    public ConnectionManager setTransaction(Transaction transaction) {
        this.transaction = transaction;
        return this;
    }

    public ITransaction getOrSetTransaction(DataSource datasource) {
        if (this.isInTransaction()) {
            return this.getTransaction();
        }
        return this.beginTransaction(datasource);
    }

    public ITransaction beginTransaction(DataSource datasource) {
        if (this.isInTransaction()) {
            this.transaction = new ChildTransaction(this.transaction);
            logger.debug("Opened CHILD transaction {}", (Object)this.transaction);
        } else {
            this.transaction = new Transaction(datasource);
            logger.debug("Opened transaction {}", (Object)this.transaction);
        }
        return this.transaction;
    }

    public ConnectionManager endTransaction() {
        this.transaction.end();
        ITransaction iTransaction = this.transaction;
        if (iTransaction instanceof ChildTransaction) {
            ChildTransaction childTransaction = (ChildTransaction)iTransaction;
            logger.debug("Ending CHILD transaction {} and repointing the context transaction to the parent transaction {}", (Object)this.transaction, (Object)childTransaction.getParent());
            this.transaction = childTransaction.getParent();
        } else {
            logger.debug("Ending transaction {}", (Object)this.transaction);
            this.transaction = null;
        }
        return this;
    }

    public Connection getConnection(DataSource datasource, String username, String password) {
        if (this.isInTransaction()) {
            logger.debug("Am inside transaction context; will check datasource and authentication to determine if we should return the transactional connection");
            DataSource transactionalDatasource = this.getTransaction().getDataSource();
            if (transactionalDatasource == null) {
                logger.debug("Transaction datasource is null; setting it to the provided datasource");
                return this.getTransaction().setDataSource(datasource).getDataSource().getConnection();
            }
            boolean isSameDatasource = transactionalDatasource.equals(datasource);
            if (isSameDatasource && (username == null || transactionalDatasource.isAuthenticationMatch(username, password).booleanValue())) {
                logger.debug("Both the query datasource argument and authentication matches; proceeding with established transactional connection");
                return this.getTransaction().getConnection();
            }
            logger.debug("Datasource OR authentication does not match transaction; Will ignore transaction context and return a new JDBC connection");
            return datasource.getConnection(username, password);
        }
        logger.debug("Not within transaction; obtaining new connection from pool");
        return datasource.getConnection(username, password);
    }

    public boolean releaseConnection(Connection connection) {
        if (this.isInTransaction()) {
            logger.debug("Am inside transaction context; skipping connection release.");
            return false;
        }
        try {
            if (connection == null || connection.isClosed()) {
                logger.debug("Connection is null or already closed; skipping connection release.");
                return false;
            }
            logger.debug("Releasing connection {}", (Object)connection);
            connection.close();
        }
        catch (SQLException e) {
            throw new BoxRuntimeException("Error releasing connection: " + e.getMessage(), e);
        }
        return true;
    }

    public Connection getConnection(DataSource datasource) {
        if (this.isInTransaction()) {
            logger.debug("Am inside transaction context; will check datasource to determine if we should return the transactional connection");
            DataSource transactionalDatasource = this.getTransaction().getDataSource();
            if (transactionalDatasource == null) {
                logger.debug("Transaction datasource is null; setting it to the provided datasource");
                return this.getTransaction().setDataSource(datasource).getDataSource().getConnection();
            }
            boolean isSameDatasource = transactionalDatasource.equals(datasource);
            if (isSameDatasource) {
                logger.debug("The query datasource matches the transaction datasource; proceeding with established transactional connection");
                return this.getTransaction().getConnection();
            }
            logger.debug("Datasource does not match transaction; Will ignore transaction context and return a new JDBC connection");
            return datasource.getConnection();
        }
        logger.debug("Not within transaction; obtaining new connection from the datasource object");
        return datasource.getConnection();
    }

    public Connection getConnection(QueryOptions options) {
        if (options.wantsUsernameAndPassword()) {
            return this.getConnection(this.getDataSource(options), options.username, options.password);
        }
        return this.getConnection(this.getDataSource(options));
    }

    public DataSource getDataSource(QueryOptions options) {
        if (options.datasource != null) {
            Object datasourceObject = options.datasource;
            CastAttempt<IStruct> datasourceAsStruct = StructCaster.attempt(datasourceObject);
            if (datasourceAsStruct.wasSuccessful()) {
                return this.getOnTheFlyDataSource(datasourceAsStruct.get());
            }
            if (datasourceObject instanceof String) {
                String datasourceName = (String)datasourceObject;
                return this.getDatasourceOrThrow(Key.of(datasourceName));
            }
            throw new BoxRuntimeException("Invalid datasource type: " + datasourceObject.getClass().getName());
        }
        return this.getDefaultDatasourceOrThrow();
    }

    public DataSource getDefaultDatasource() {
        if (this.defaultDatasource != null) {
            return this.defaultDatasource;
        }
        String defaultDSN = (String)this.context.getConfigItems(Key.defaultDatasource);
        Key defaultDSNKey = Key.of(defaultDSN);
        IStruct configDatasources = (IStruct)this.context.getConfigItems(Key.datasources);
        if (defaultDSN.isEmpty() || !configDatasources.containsKey(defaultDSNKey)) {
            return null;
        }
        IStruct targetConfig = configDatasources.getAsStruct(defaultDSNKey);
        DatasourceConfig dsn = new DatasourceConfig(defaultDSNKey).process(targetConfig).withAppName(this.getApplicationName());
        this.defaultDatasource = this.datasourceService.register(dsn);
        return this.defaultDatasource;
    }

    public DataSource getDefaultDatasourceOrThrow() {
        DataSource datasource = this.getDefaultDatasource();
        if (datasource == null) {
            throw new DatabaseException("No default datasource defined in the application or globally or in the query options");
        }
        return datasource;
    }

    public DataSource getDatasource(Key datasourceName) {
        DataSource target = this.datasources.get(datasourceName);
        if (target != null) {
            return target;
        }
        IStruct configDatasources = this.context.getConfig().getAsStruct(Key.datasources);
        if (!configDatasources.containsKey(datasourceName)) {
            return null;
        }
        DatasourceConfig dsnConfig = new DatasourceConfig(datasourceName).process(configDatasources.getAsStruct(datasourceName)).withAppName(this.getApplicationName());
        DataSource dsn = this.datasourceService.register(dsnConfig);
        this.datasources.put(datasourceName, dsn);
        return dsn;
    }

    public DataSource register(DataSource target) {
        this.datasources.put(target.getConfiguration().name, target);
        return target;
    }

    public DataSource register(Key datasourceName, IStruct properties) {
        DataSource target = this.datasourceService.register(new DatasourceConfig(datasourceName, properties));
        this.datasources.put(datasourceName, target);
        return target;
    }

    public DataSource getDatasourceOrThrow(Key datasourceName) {
        DataSource datasource = this.getDatasource(datasourceName);
        if (datasource == null) {
            throw new DatabaseException("Datasource with name [" + datasourceName.getName() + "] not found in the application or globally");
        }
        return datasource;
    }

    public DataSource getOnTheFlyDataSource(IStruct properties) {
        Key datasourceName = Key.of("onthefly_" + properties.hashCode());
        DataSource target = this.datasources.get(datasourceName);
        if (target != null) {
            return target;
        }
        DatasourceConfig config = new DatasourceConfig(Key.of(datasourceName.getName()), properties).withAppName(this.getApplicationName()).setOnTheFly();
        target = this.datasourceService.register(config);
        this.datasources.put(datasourceName, target);
        return target;
    }

    public ConnectionManager setDefaultDatasource(DataSource datasource) {
        this.defaultDatasource = datasource;
        return this;
    }

    public boolean hasDefaultDatasource() {
        return this.defaultDatasource != null;
    }

    public int getCachedDatasourcesCount() {
        return this.datasources.size();
    }

    public String[] getCachedDatasourcesNames() {
        return (String[])this.datasources.keySet().stream().map(Key::getName).sorted().toArray(String[]::new);
    }

    public boolean hasCachedDatasource(Key datasourceName) {
        return this.datasources.containsKey(datasourceName);
    }

    public Map<Key, DataSource> getCachedDatasources() {
        return this.datasources;
    }

    public void shutdown() {
        this.datasources.clear();
    }

    public void shutdownExceptionally() {
        this.shutdown();
    }

    private Key getApplicationName() {
        ApplicationBoxContext appContext = this.context.getParentOfType(ApplicationBoxContext.class);
        if (appContext != null) {
            return appContext.getApplication().getName();
        }
        return Key._EMPTY;
    }
}

