/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import com.zaxxer.hikari.HikariDataSource;
import com.zaxxer.hikari.HikariPoolMXBean;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.config.segments.DatasourceConfig;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.ExecutedQuery;
import ortus.boxlang.runtime.jdbc.PendingQuery;
import ortus.boxlang.runtime.jdbc.QueryOptions;
import ortus.boxlang.runtime.jdbc.QueryParameter;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.BoxRuntimeException;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;

public class DataSource
implements Comparable<DataSource> {
    private final HikariDataSource hikariDataSource;
    private final DatasourceConfig configuration;

    public DataSource(DatasourceConfig config) {
        IStruct eventParams = Struct.of(new Object[]{"name", config.getUniqueName(), "properties", config.properties, "config", config});
        BoxRuntime.getInstance().getInterceptorService().announce(BoxEvent.ON_DATASOURCE_STARTUP, eventParams);
        this.configuration = eventParams.getAs(DatasourceConfig.class, Key.of("config"));
        try {
            this.hikariDataSource = new HikariDataSource(this.configuration.toHikariConfig());
        }
        catch (RuntimeException e) {
            throw new BoxRuntimeException("Unable to create datasource connection: " + e.getMessage(), e);
        }
    }

    public static DataSource fromStruct(String name, IStruct properties) {
        return DataSource.fromStruct(Key.of(name), properties);
    }

    public static DataSource fromStruct(Key name, IStruct properties) {
        return new DataSource(new DatasourceConfig(name, properties));
    }

    public String getOriginalName() {
        return this.configuration.getOriginalName();
    }

    public Key getUniqueName() {
        return this.configuration.getUniqueName();
    }

    public Boolean isOnTheFly() {
        return this.configuration.isOnTheFly();
    }

    public int hashCode() {
        return this.getUniqueName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        DataSource other = (DataSource)obj;
        return this.getUniqueName().equals(other.getUniqueName());
    }

    @Override
    public int compareTo(DataSource otherConfig) {
        return this.getUniqueName().compareTo(otherConfig.getUniqueName());
    }

    public DatasourceConfig getConfiguration() {
        return this.configuration;
    }

    public Connection getConnection() {
        try {
            return this.hikariDataSource.getConnection();
        }
        catch (SQLException e) {
            throw new BoxRuntimeException("Unable to open connection:", e);
        }
    }

    public Connection getConnection(String username, String password) {
        try {
            return this.hikariDataSource.getConnection(username, password);
        }
        catch (SQLException e) {
            throw new BoxRuntimeException("Unable to open connection:", e);
        }
    }

    public DataSource shutdown() {
        this.hikariDataSource.close();
        return this;
    }

    public ExecutedQuery execute(String query) {
        ExecutedQuery executedQuery;
        block8: {
            Connection conn = this.getConnection();
            try {
                executedQuery = this.execute(query, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            conn.close();
        }
        return executedQuery;
    }

    public ExecutedQuery execute(String query, Connection conn) {
        PendingQuery pendingQuery = new PendingQuery(query, new ArrayList<QueryParameter>());
        return pendingQuery.execute(conn);
    }

    public ExecutedQuery execute(String query, List<QueryParameter> parameters, Connection conn) {
        PendingQuery pendingQuery = new PendingQuery(query, parameters);
        return pendingQuery.execute(conn);
    }

    public ExecutedQuery execute(String query, List<QueryParameter> parameters) {
        ExecutedQuery executedQuery;
        block8: {
            Connection conn = this.getConnection();
            try {
                executedQuery = this.execute(query, parameters, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            conn.close();
        }
        return executedQuery;
    }

    public ExecutedQuery execute(String query, Array parameters, Connection conn) {
        PendingQuery pendingQuery = new PendingQuery(query, parameters, new QueryOptions(new Struct()));
        return pendingQuery.execute(conn);
    }

    public ExecutedQuery execute(String query, Array parameters) {
        ExecutedQuery executedQuery;
        block8: {
            Connection conn = this.getConnection();
            try {
                executedQuery = this.execute(query, parameters, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            conn.close();
        }
        return executedQuery;
    }

    public ExecutedQuery execute(String query, IStruct parameters, Connection conn) {
        PendingQuery pendingQuery = new PendingQuery(query, parameters, new QueryOptions(new Struct()));
        return pendingQuery.execute(conn);
    }

    public ExecutedQuery execute(String query, IStruct parameters) {
        ExecutedQuery executedQuery;
        block8: {
            Connection conn = this.getConnection();
            try {
                executedQuery = this.execute(query, parameters, conn);
                if (conn == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (conn != null) {
                        try {
                            conn.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            conn.close();
        }
        return executedQuery;
    }

    public Boolean isAuthenticationMatch(String username, String password) {
        return this.hikariDataSource.getUsername().equals(username) && this.hikariDataSource.getPassword().equals(password);
    }

    public HikariDataSource getHikariDataSource() {
        return this.hikariDataSource;
    }

    public IStruct getPoolStats() {
        HikariPoolMXBean pool = this.hikariDataSource.getHikariPoolMXBean();
        return Struct.of(new Object[]{"pendingThreads", pool.getThreadsAwaitingConnection(), "idleConnections", pool.getIdleConnections(), "totalConnections", pool.getTotalConnections(), "activeConnections", pool.getActiveConnections(), "maxConnections", this.hikariDataSource.getMaximumPoolSize(), "minConnections", this.hikariDataSource.getMinimumIdle()});
    }
}

