/*
 * Decompiled with CFR 0.152.
 */
package ortus.boxlang.runtime.jdbc;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ortus.boxlang.runtime.BoxRuntime;
import ortus.boxlang.runtime.events.BoxEvent;
import ortus.boxlang.runtime.jdbc.PendingQuery;
import ortus.boxlang.runtime.scopes.Key;
import ortus.boxlang.runtime.services.InterceptorService;
import ortus.boxlang.runtime.types.Array;
import ortus.boxlang.runtime.types.IStruct;
import ortus.boxlang.runtime.types.Query;
import ortus.boxlang.runtime.types.Struct;
import ortus.boxlang.runtime.types.exceptions.DatabaseException;

public final class ExecutedQuery {
    private static final InterceptorService interceptorService = BoxRuntime.getInstance().getInterceptorService();
    private static final Logger logger = LoggerFactory.getLogger(ExecutedQuery.class);
    @Nonnull
    private final Query results;
    @Nullable
    private Object generatedKey;
    private IStruct queryMeta;

    public ExecutedQuery(@Nonnull Query results, @Nullable Object generatedKey, @Nullable IStruct queryMeta) {
        this.results = results;
        this.generatedKey = generatedKey;
        this.queryMeta = queryMeta;
        this.queryMeta.putIfAbsent(Key.executionTime, (Object)0);
        this.queryMeta.putIfAbsent(Key.cached, (Object)false);
        this.queryMeta.putIfAbsent(Key.cacheKey, (Object)null);
        this.queryMeta.putIfAbsent(Key.cacheProvider, (Object)null);
        this.queryMeta.computeIfAbsent(Key.cacheTimeout, key -> Duration.ZERO);
        this.queryMeta.computeIfAbsent(Key.cacheLastAccessTimeout, key -> Duration.ZERO);
        this.results.setMetadata(this.queryMeta);
    }

    public static ExecutedQuery fromCachedQuery(@Nonnull ExecutedQuery cachedQuery, IStruct cacheMeta) {
        Struct queryMeta = new Struct(cachedQuery.getQueryMeta());
        queryMeta.addAll(cacheMeta);
        return new ExecutedQuery(cachedQuery.getResults(), cachedQuery.getGeneratedKey(), queryMeta);
    }

    public static ExecutedQuery fromPendingQuery(@Nonnull PendingQuery pendingQuery, @Nonnull Statement statement, long executionTime, boolean hasResults) {
        IStruct queryMeta;
        Query results;
        Object generatedKey;
        block21: {
            generatedKey = null;
            results = null;
            queryMeta = Struct.of(new Object[]{"cached", false, "sql", pendingQuery.getOriginalSql(), "sqlParameters", Array.fromList(pendingQuery.getParameterValues()), "executionTime", executionTime});
            try (ResultSet rs = statement.getResultSet();){
                results = Query.fromResultSet(rs);
            }
            catch (SQLException e) {
                throw new DatabaseException(e.getMessage(), e);
            }
            try {
                try (ResultSet keys = statement.getGeneratedKeys();){
                    if (keys != null && keys.next()) {
                        generatedKey = keys.getObject(1);
                    }
                }
                catch (SQLException e) {
                    if (e.getMessage().contains("The statement must be executed before any results can be obtained.")) {
                        logger.info("SQL Server threw an error when attempting to retrieve generated keys. Am ignoring the error - no action is required. Error : [{}]", (Object)e.getMessage());
                        break block21;
                    }
                    throw new DatabaseException(e.getMessage(), e);
                }
            }
            catch (NullPointerException e) {
                if (e.getMessage().equals("Cannot invoke \"java.sql.ResultSet.next()\" because \"this.delegate\" is null")) break block21;
                throw e;
            }
        }
        ExecutedQuery executedQuery = new ExecutedQuery(results, generatedKey, queryMeta);
        interceptorService.announce(BoxEvent.POST_QUERY_EXECUTE, Struct.of(new Object[]{"sql", queryMeta.getAsString(Key.sql), "bindings", pendingQuery.getParameterValues(), "executionTime", executionTime, "data", results, "result", queryMeta, "pendingQuery", pendingQuery, "executedQuery", executedQuery}));
        return executedQuery;
    }

    @Nonnull
    public Query getResults() {
        return this.results;
    }

    @Nonnull
    public Array getResultsAsArray() {
        return this.results.toStructArray();
    }

    @Nonnull
    public IStruct getResultsAsStruct(@Nonnull String key) {
        Map<Object, List<IStruct>> groupedResults = this.results.stream().collect(Collectors.groupingBy(r -> r.get(key)));
        Map<Object, Object> groupedArray = groupedResults.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> new Array((List)e.getValue())));
        return Struct.fromMap(IStruct.TYPES.LINKED, groupedArray);
    }

    public int getRecordCount() {
        return this.results.size();
    }

    @Nonnull
    private IStruct getQueryMeta() {
        return this.queryMeta;
    }

    @Nullable
    public Object getGeneratedKey() {
        return this.generatedKey;
    }
}

